/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.ta.splaso;

import cz.vutbr.fit.ta.core.ResourceFactory;
import cz.vutbr.fit.ta.core.TimelineSource;
import cz.vutbr.fit.ta.ontology.Event;
import cz.vutbr.fit.ta.ontology.FileDownloadEvent;
import cz.vutbr.fit.ta.ontology.LocalFile;
import cz.vutbr.fit.ta.ontology.Timeline;
import cz.vutbr.fit.ta.ontology.URLVisitEvent;
import cz.vutbr.fit.ta.ontology.WebResource;
import cz.vutbr.fit.ta.splaso.PlasoEntry;
import cz.vutbr.fit.ta.splaso.model.PlasoEntityFactory;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;

public class SparkPlasoSource
extends TimelineSource {
    private static final String DATA_TYPE_KEY = "data_type";
    private static final String TIMESTAMP_KEY = "timestamp";
    private static final String URL_KEY = "url";
    private static final String FILE_PATH_KEY = "full_path";
    private static final String TITLE_KEY = "title";
    private int idCnt = 0;
    private String profileId;
    private List<PlasoEntry> entries;

    public SparkPlasoSource(String profileId, List<PlasoEntry> entries) {
        this.profileId = profileId;
        this.entries = entries;
    }

    @Override
    public Timeline getTimeline() {
        PlasoEntityFactory factory = PlasoEntityFactory.getInstance();
        Timeline timeline = factory.createTimeline(this.profileId);
        timeline.setSourceId(this.profileId);
        for (PlasoEntry entry : this.entries) {
            Event ev = this.parseEvent(entry);
            if (ev == null) continue;
            timeline.addEvent(ev);
        }
        return timeline;
    }

    private Event parseEvent(PlasoEntry entry) {
        if (entry.getEventData().get(DATA_TYPE_KEY) != null) {
            switch (entry.getEventData().get(DATA_TYPE_KEY)) {
                case "firefox:places:page_visited": 
                case "chrome:history:page_visited": {
                    return this.createPageVisit(entry);
                }
                case "chrome:history:file_downloaded": {
                    return this.createFileDownload(entry);
                }
            }
            return null;
        }
        return null;
    }

    private Event createPageVisit(PlasoEntry entry) {
        WebResource wres;
        PlasoEntityFactory factory = PlasoEntityFactory.getInstance();
        URLVisitEvent ev = factory.createURLVisitEvent(ResourceFactory.createResourceIRI("plaso", "visit", String.valueOf(this.idCnt++)));
        if (entry.getEvent().containsKey(TIMESTAMP_KEY)) {
            Date ts = this.decodeTimestamp(entry);
            ev.setTimestamp(ts);
        }
        if ((wres = this.createWebResource(entry)) != null) {
            wres.addEvent(ev);
        }
        return ev;
    }

    private Event createFileDownload(PlasoEntry entry) {
        LocalFile file;
        WebResource wres;
        PlasoEntityFactory factory = PlasoEntityFactory.getInstance();
        FileDownloadEvent ev = factory.createFileDownloadEvent(ResourceFactory.createResourceIRI("plaso", "download", String.valueOf(this.idCnt++)));
        if (entry.getEvent().containsKey(TIMESTAMP_KEY)) {
            Date ts = this.decodeTimestamp(entry);
            ev.setTimestamp(ts);
        }
        if ((wres = this.createWebResource(entry)) != null) {
            wres.addEvent(ev);
        }
        if ((file = this.createLocalFile(entry)) != null) {
            file.addEvent(ev);
        }
        return ev;
    }

    private WebResource createWebResource(PlasoEntry entry) {
        PlasoEntityFactory factory = PlasoEntityFactory.getInstance();
        String urlString = entry.getEventData().get(URL_KEY);
        if (urlString != null) {
            WebResource ret = factory.createWebResource(ResourceFactory.createUrlIRI(urlString));
            ret.setSourceUrl(urlString);
            if (entry.getEventData().get(TITLE_KEY) != null) {
                ret.setResourceTitle(entry.getEventData().get(TITLE_KEY));
            }
            return ret;
        }
        return null;
    }

    private LocalFile createLocalFile(PlasoEntry entry) {
        PlasoEntityFactory factory = PlasoEntityFactory.getInstance();
        String pathString = entry.getEventData().get(FILE_PATH_KEY);
        pathString = pathString.replace('\\', '/');
        if ((pathString = pathString.replace("//", "/")) != null) {
            LocalFile ret = factory.createLocalFile(ResourceFactory.createFileIRI(this.profileId, pathString));
            ret.setPath(pathString);
            ret.setFileName(this.extractFileName(pathString));
            return ret;
        }
        return null;
    }

    private Date decodeTimestamp(PlasoEntry entry) {
        String microts = entry.getEvent().get(TIMESTAMP_KEY);
        if (microts != null) {
            long micros = Long.valueOf(microts);
            return new Date(micros / 1000L);
        }
        return null;
    }

    private String extractFileName(String path) {
        Path p = Paths.get(path, new String[0]);
        return p.getFileName().toString();
    }
}

