/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.dawg;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.rdf4j.model.Graph;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.GraphImpl;
import org.eclipse.rdf4j.model.util.GraphUtil;
import org.eclipse.rdf4j.model.util.GraphUtilException;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.dawg.DAWGTestResultSetSchema;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.impl.SimpleBinding;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFHandler;

public class DAWGTestResultSetParser
extends AbstractRDFHandler {
    private final TupleQueryResultHandler tqrHandler;
    private Graph graph = new GraphImpl();

    public DAWGTestResultSetParser(TupleQueryResultHandler tqrHandler) {
        this.tqrHandler = tqrHandler;
    }

    @Override
    public void startRDF() throws RDFHandlerException {
        this.graph.clear();
    }

    @Override
    public void handleStatement(Statement st) throws RDFHandlerException {
        this.graph.add(st);
    }

    @Override
    public void endRDF() throws RDFHandlerException {
        try {
            Resource resultSetNode = GraphUtil.getUniqueSubject(this.graph, RDF.TYPE, DAWGTestResultSetSchema.RESULTSET, new Resource[0]);
            List<String> bindingNames = this.getBindingNames(resultSetNode);
            this.tqrHandler.startQueryResult(bindingNames);
            Iterator<Value> solIter = GraphUtil.getObjectIterator(this.graph, resultSetNode, DAWGTestResultSetSchema.SOLUTION, new Resource[0]);
            while (solIter.hasNext()) {
                Value solutionNode = solIter.next();
                if (solutionNode instanceof Resource) {
                    this.reportSolution((Resource)solutionNode, bindingNames);
                    continue;
                }
                throw new RDFHandlerException("Value for " + DAWGTestResultSetSchema.SOLUTION + " is not a resource: " + solutionNode);
            }
            this.tqrHandler.endQueryResult();
        }
        catch (GraphUtilException e) {
            throw new RDFHandlerException(e.getMessage(), e);
        }
        catch (TupleQueryResultHandlerException e) {
            throw new RDFHandlerException(e.getMessage(), e);
        }
    }

    private List<String> getBindingNames(Resource resultSetNode) throws RDFHandlerException {
        ArrayList<String> bindingNames = new ArrayList<String>(16);
        Iterator<Value> varIter = GraphUtil.getObjectIterator(this.graph, resultSetNode, DAWGTestResultSetSchema.RESULTVARIABLE, new Resource[0]);
        while (varIter.hasNext()) {
            Value varName = varIter.next();
            if (varName instanceof Literal) {
                bindingNames.add(((Literal)varName).getLabel());
                continue;
            }
            throw new RDFHandlerException("Value for " + DAWGTestResultSetSchema.RESULTVARIABLE + " is not a literal: " + varName);
        }
        return bindingNames;
    }

    private void reportSolution(Resource solutionNode, List<String> bindingNames) throws RDFHandlerException, GraphUtilException {
        MapBindingSet bindingSet = new MapBindingSet(bindingNames.size());
        Iterator<Value> bindingIter = GraphUtil.getObjectIterator(this.graph, solutionNode, DAWGTestResultSetSchema.BINDING, new Resource[0]);
        while (bindingIter.hasNext()) {
            Value bindingNode = bindingIter.next();
            if (bindingNode instanceof Resource) {
                Binding binding = this.getBinding((Resource)bindingNode);
                bindingSet.addBinding(binding);
                continue;
            }
            throw new RDFHandlerException("Value for " + DAWGTestResultSetSchema.BINDING + " is not a resource: " + bindingNode);
        }
        try {
            this.tqrHandler.handleSolution(bindingSet);
        }
        catch (TupleQueryResultHandlerException e) {
            throw new RDFHandlerException(e.getMessage(), e);
        }
    }

    private Binding getBinding(Resource bindingNode) throws GraphUtilException {
        Literal name = GraphUtil.getUniqueObjectLiteral(this.graph, bindingNode, DAWGTestResultSetSchema.VARIABLE);
        Value value = GraphUtil.getUniqueObject(this.graph, bindingNode, DAWGTestResultSetSchema.VALUE, new Resource[0]);
        return new SimpleBinding(name.getLabel(), value);
    }
}

