/******************************************************************************
* TASTE (Testability Analysis SuiTE) version 1.00
* Copyright (c) 2008 Josef Strnadel, all rights reserved
* Brno University of Technology, Faculty of Information Technology
* -----------------------------------------------------------------------------
* This is a free software: you can redistribute it and/or modify it 
* under the terms of the latest version of the GNU Lesser General Public License 
* as published by the Free Software Foundation.
* 
* This software is distributed in the hope that it will be useful, 
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
* See the GNU General Public License and the GNU Lesser General Public License 
* for more details.
* 
* You should have received a copy of the GNU General Public License
* and GNU Lesser General Public License along with this software. 
* If not, see <http://www.gnu.org/licenses/>.
* -----------------------------------------------------------------------------
* filename:     misc.cc
* version:      1.00
* started:      25. 4. 2007
* last revised: 21. 7. 2008
* language:     ANSI C++
* author:       Josef Strnadel
*               web:      http://www.fit.vutbr.cz/~strnadel/index.php.en
*               e-mail:   strnadel@fit.vutbr.cz
*               address:  Bozetechova 2, 61266 Brno, Czech Republic
*               phone:    +420 54114-1211
*               fax:      +420 54114-1270
* -----------------------------------------------------------------------------
* description:	miscelaneous functions
* -----------------------------------------------------------------------------
* notes:        -
* -----------------------------------------------------------------------------
* history of modifications:
*               -
* -----------------------------------------------------------------------------
* known bugs:   -
******************************************************************************/
//! \file misc.cc module with miscelaneous functions

#include <iostream>
#include <sstream>
#include <string>

#include <stdio.h>
#include <stdlib.h>

using namespace std;

extern bool debug_mode;
extern unsigned long nerrors;

/******************************************************************************
*	string-related functions
******************************************************************************/

//!  test whether string contains an integer or not
bool isInt(string s)
{
  //bool res=(s.size()!=0);
  bool res= true;
  for(unsigned int i=0; i<s.size(); i++)
  {
    res=(res&&isdigit(s[i]));
    if(!res) break;
  }
  return res;
}

//! converts string to '0+' integer
int str2int(string s)
{
  if(isInt(s)) {stringstream ss; int i; ss << s; ss >> i; return(i);}
  else return(-1);
}

//! converts integer to string
string int2str(int i)
{
  stringstream ss; string s; 
  ss << i; ss >> s; 
  return(s);
}

//!  returns sub-string apearing before substr in str
/*!
    @param[in] str string a substring is searched in
    @param[in] substr searched substring 
*/
string str_before(string str, string substr)
{
  unsigned int i=str.find(substr);
  if(i==string::npos) {return("");}
  else return(str.erase(i));
}

//!  returns sub-string apearing between sub_l (left) and sub_r (right) in str
/*!
    @param[in] str string a substring is searched in
    @param[in] sub_l substring placed on the left of searched substring 
    @param[in] sub_r substring placed on the right of searched substring 
*/
string str_between(string str, string sub_l, string sub_r)
{
  unsigned int il=str.find(sub_l);
  unsigned int ir=str.find(sub_r);
  if((il==string::npos) || (ir==string::npos) || (il>=ir)) {return("");}
  else {str.erase(ir); str.erase(0, il+sub_l.size()); return(str);}
}

//!  returns sub-string apearing after substr in str
/*!
    @param[in] str string a substring is searched in
    @param[in] substr searched substring 
*/
string str_after(string str, string substr)
{
  unsigned int i=str.find(substr);
  if(i==string::npos) {return("");}
  else return(str.erase(0,i+substr.size()));
}

//! replaces sub placed in str by val
/*!
    @param[in] str string a substring is searched in
    @param[in] sub searched substring 
    @param[in] val string-value to replace sub in str
*/
string replaceSubstrWithVal(string str, string sub, string val)
{
  string res="";
  unsigned int i;

  if(debug_mode) cout << "str: '" << str << ", sub: '" << sub << "', val: '" << val << "'"<< endl;
  
  if(isInt(sub)) {return(sub);}
  
  res = str;
  
  while((i=str.find(sub)) != string::npos) // replace each sub by the value
  {
    string str2 = val;
    str.replace(i, sub.size(), str2);
    res = str;
  }

  if(debug_mode) cout << "result-string: '" << str << "'"<< endl;

  return(res);
}
