/******************************************************************************
* TASTE (Testability Analysis SuiTE) version 1.00
* Copyright (c) 2008 Josef Strnadel, all rights reserved
* Brno University of Technology, Faculty of Information Technology
* -----------------------------------------------------------------------------
* This is a free software: you can redistribute it and/or modify it 
* under the terms of the latest version of the GNU Lesser General Public License 
* as published by the Free Software Foundation.
* 
* This software is distributed in the hope that it will be useful, 
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
* See the GNU General Public License and the GNU Lesser General Public License 
* for more details.
* 
* You should have received a copy of the GNU General Public License
* and GNU Lesser General Public License along with this software. 
* If not, see <http://www.gnu.org/licenses/>.
* -----------------------------------------------------------------------------
* filename:     defs.h
* version:      1.00
* started:      25. 4. 2007
* last revised: 21. 7. 2008
* language:     ANSI C++
* author:       Josef Strnadel
*               web:      http://www.fit.vutbr.cz/~strnadel/index.php.en
*               e-mail:   strnadel@fit.vutbr.cz
*               address:  Bozetechova 2, 61266 Brno, Czech Republic
*               phone:    +420 54114-1211
*               fax:      +420 54114-1270
* -----------------------------------------------------------------------------
* description:	basic definitions module
* -----------------------------------------------------------------------------
* notes:        -
* -----------------------------------------------------------------------------
* history of modifications:
*               -
* -----------------------------------------------------------------------------
* known bugs:   -
******************************************************************************/
//! \file defs.h common definitions and constants

#ifndef _DEFS_H_
#define _DEFS_H_

/*!\brief string length limit */
const unsigned long MAX_STR_LEN = 255;

/*!\brief character for separation of hirerarchical names */
const char NAME_SEPARATOR = '.';

/*!\brief possible types of in-circuit nodes */
typedef enum tNode 
{
  NODE_IN=1, 
  NODE_OUT=2, 
  NODE_CLK=4, 
  NODE_CTRL=8
};

/*!\brief operation used to evaluate penalty during mark transportation process */
typedef enum tProPen 
{
  PP_LIN=1, 
  PP_EXP=2
};

/*!\brief type of sequential length estimation */
typedef enum tSeqEst 
{
  SE_BASIC=1, 
  SE_PRECISE=2
};

/*!\brief id for ordered-scan technique */
const int ORDERED_SCAN = 1;

/*!\brief id for unordered-scan technique */
const int UNORDERED_SCAN = 2;

/*!\brief id for test-point-insertion technique */
const int TEST_POINT_INSERTION = 4;

/*!\brief id for BIST technique */
const int BIST = 8;

#endif
