/*
 * Decompiled with CFR 0.152.
 */
package org.ndx.pcap;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.ndx.pcap.PcapReader;
import org.ndx.pcap.PcapRecordReader;

public class PcapInputFormat
extends FileInputFormat<LongWritable, ObjectWritable> {
    private static final String READER_CLASS_PROPERTY = "ndx.spark.pcap.reader.class";
    public static final Log LOG = LogFactory.getLog(PcapInputFormat.class);

    public RecordReader<LongWritable, ObjectWritable> getRecordReader(InputSplit split, JobConf config, Reporter reporter) throws IOException {
        FileSplit fileSplit = (FileSplit)split;
        Path path = fileSplit.getPath();
        LOG.info((Object)("Reading PCAP: " + path.toString()));
        long start = 0L;
        long length = fileSplit.getLength();
        return PcapInputFormat.initPcapRecordReader(path, start, length, reporter, (Configuration)config);
    }

    public static PcapRecordReader initPcapRecordReader(Path path, long start, long length, Reporter reporter, Configuration conf) throws IOException {
        FSDataInputStream baseStream;
        FileSystem fs = path.getFileSystem(conf);
        Object stream = baseStream = fs.open(path);
        CompressionCodecFactory compressionCodecs = new CompressionCodecFactory(conf);
        CompressionCodec codec = compressionCodecs.getCodec(path);
        if (codec != null) {
            stream = new DataInputStream((InputStream)codec.createInputStream((InputStream)stream));
        }
        PcapReader reader = PcapInputFormat.initPcapReader((DataInputStream)stream, conf);
        return new PcapRecordReader(reader, start, length, (Seekable)baseStream, (DataInputStream)stream, reporter);
    }

    public static PcapReader initPcapReader(DataInputStream stream, Configuration conf) throws IOException {
        try {
            Class pcapReaderClass = conf.getClass(READER_CLASS_PROPERTY, PcapReader.class, PcapReader.class);
            Constructor pcapReaderConstructor = pcapReaderClass.getConstructor(DataInputStream.class);
            return (PcapReader)pcapReaderConstructor.newInstance(stream);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected boolean isSplitable(FileSystem fs, Path filename) {
        return false;
    }
}

