/*
 * Decompiled with CFR 0.152.
 */
package org.ndx.model.parsers.applayer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ndx.model.Packet;
import org.ndx.model.json.JsonAdapter;
import org.ndx.model.json.JsonHelper;
import org.ndx.model.parsers.applayer.AppLayerParser;
import org.ndx.model.parsers.applayer.DnsHelper;

public class DnsJsonParser
extends AppLayerParser {
    private static final Log LOG = LogFactory.getLog(DnsJsonParser.class);
    private static final String JSON_DNS_COUNT_QUERIES = "dns_dns_count_queries";
    private static final String JSON_DNS_COUNT_ANSWERS = "dns_dns_count_answers";
    private static final String JSON_DNS_COUNT_AUTH = "dns_dns_count_auth_rr";
    private static final String JSON_DNS_COUNT_ADD = "dns_dns_count_add_rr";
    private static final String JSON_DNS_QUERY_OR_RESPONSE = "dns_flags_dns_flags_response";
    private static final String JSON_DNS_ID = "dns_dns_id";
    private static final String JSON_DNS_QUERY_NAME = "text_dns_qry_name";
    private static final String JSON_DNS_QUERY_TYPE = "text_dns_qry_type";
    private static final String JSON_DNS_QUERY_CLASS = "text_dns_qry_class";
    private static final String JSON_DNS_RESP_NAME = "text_dns_resp_name";
    private static final String JSON_DNS_RESP_TYPE = "text_dns_resp_type";
    private static final String JSON_DNS_RESP_CLASS = "text_dns_resp_class";
    private static final String JSON_DNS_TEXT = "text_text";
    private int rdataIndex = 0;

    public DnsJsonParser(int packetNo) {
        this.packetNumber = packetNo;
        this.init();
    }

    public DnsJsonParser() {
        this.init();
    }

    private void init() {
        this.put("dns_queries", new ArrayList());
        this.put("dns_answers", new ArrayList());
        this.put("dns_query_cnt", 0);
        this.put("dns_answer_cnt", 0);
        this.put("dns_auth_cnt", 0);
        this.put("dns_add_cnt", 0);
    }

    public void parse(JsonAdapter payload) {
        JsonHelper.addValue(this.packetNumber, this, "dns_id", payload, JSON_DNS_ID, JsonHelper.ValueTypes.INT);
        JsonHelper.addValue(this.packetNumber, this, "dns_query_response", payload, JSON_DNS_QUERY_OR_RESPONSE, JsonHelper.ValueTypes.BOOLEAN);
        JsonHelper.addValue(this.packetNumber, this, "dns_query_cnt", payload, JSON_DNS_COUNT_QUERIES, JsonHelper.ValueTypes.INT);
        JsonHelper.addValue(this.packetNumber, this, "dns_answer_cnt", payload, JSON_DNS_COUNT_ANSWERS, JsonHelper.ValueTypes.INT);
        JsonHelper.addValue(this.packetNumber, this, "dns_auth_cnt", payload, JSON_DNS_COUNT_AUTH, JsonHelper.ValueTypes.INT);
        JsonHelper.addValue(this.packetNumber, this, "dns_add_cnt", payload, JSON_DNS_COUNT_ADD, JsonHelper.ValueTypes.INT);
        this.parseJsonQueries(payload);
        this.parseJsonAnswers(payload);
    }

    private void parseJsonQueries(JsonAdapter payload) {
        int qCnt = (Integer)this.get("dns_query_cnt");
        ArrayList queries = (ArrayList)this.get("dns_queries");
        if (qCnt == 0) {
            LOG.warn((Object)(Packet.getLogPrefix(this.packetNumber) + "Malformed DNS packet: missing query in DNS payload."));
        } else if (qCnt == 1) {
            try {
                String name = payload.getStringValue(JSON_DNS_QUERY_NAME);
                String type = payload.getStringValue(JSON_DNS_QUERY_TYPE);
                String cls = payload.getStringValue(JSON_DNS_QUERY_CLASS);
                queries.add(DnsHelper.formatOutput(name, type, cls));
            }
            catch (Exception e) {
                LOG.warn((Object)(Packet.getLogPrefix(this.packetNumber) + e.getMessage()));
            }
        } else {
            try {
                ArrayList<String> names = payload.getStringArray(JSON_DNS_QUERY_NAME);
                ArrayList<String> types = payload.getStringArray(JSON_DNS_QUERY_TYPE);
                ArrayList<String> classes = payload.getStringArray(JSON_DNS_QUERY_CLASS);
                Iterator<String> itNames = names.iterator();
                Iterator<String> itTypes = types.iterator();
                Iterator<String> itClasses = classes.iterator();
                while (itNames.hasNext() && itTypes.hasNext() && itClasses.hasNext()) {
                    queries.add(DnsHelper.formatOutput(itNames.next(), itTypes.next(), itClasses.next()));
                }
            }
            catch (Exception e) {
                LOG.warn((Object)(Packet.getLogPrefix(this.packetNumber) + e.getMessage()));
            }
        }
        this.put("dns_queries", queries);
    }

    private void parseJsonAnswers(JsonAdapter payload) {
        this.rdataIndex = (Integer)this.get("dns_query_cnt");
        int allCnt = this.getAllAnswerSecCnt();
        switch (allCnt) {
            case 0: {
                break;
            }
            case 1: {
                this.getJsonAnswer(payload);
                break;
            }
            default: {
                this.getJsonMultipleAnswers(payload);
            }
        }
        this.rdataIndex = 0;
    }

    private void getJsonAnswer(JsonAdapter payload) {
        int aCnt = (Integer)this.get("dns_answer_cnt");
        if (aCnt == 1) {
            List answers = (List)this.get("dns_answers");
            try {
                String name = payload.getStringValue(JSON_DNS_RESP_NAME);
                String type = payload.getStringValue(JSON_DNS_RESP_TYPE);
                String cls = payload.getStringValue(JSON_DNS_RESP_CLASS);
                String rdata = this.getJsonRdata(payload);
                answers.add(DnsHelper.formatOutput(name, type, cls, rdata));
            }
            catch (Exception e) {
                LOG.warn((Object)(Packet.getLogPrefix(this.packetNumber) + e.getMessage()));
            }
        }
    }

    private void getJsonMultipleAnswers(JsonAdapter payload) {
        List answers = (List)this.get("dns_answers");
        int aCnt = (Integer)this.get("dns_answer_cnt");
        try {
            Iterator<String> itNames = payload.getStringArray(JSON_DNS_RESP_NAME).iterator();
            Iterator<String> itTypes = payload.getStringArray(JSON_DNS_RESP_TYPE).iterator();
            Iterator<String> itClasses = payload.getStringArray(JSON_DNS_RESP_CLASS).iterator();
            for (int i = 0; itNames.hasNext() && itTypes.hasNext() && itClasses.hasNext() && i < aCnt; ++i) {
                String type = itTypes.next();
                String rdata = this.getJsonRdata(payload);
                answers.add(DnsHelper.formatOutput(itNames.next(), type, itClasses.next(), rdata));
            }
        }
        catch (Exception e) {
            LOG.warn((Object)(Packet.getLogPrefix(this.packetNumber) + e.getMessage()));
        }
    }

    private String getJsonRdata(JsonAdapter payload) {
        String output = "";
        ArrayList<String> rdataArr = payload.getStringArray(JSON_DNS_TEXT);
        String text = rdataArr.get(this.rdataIndex++);
        String[] splits = text.split(",");
        if (splits.length > 2) {
            output = splits[splits.length - 1].trim();
        }
        return output;
    }

    private int getAllAnswerSecCnt() {
        int ans = (Integer)this.get("dns_answer_cnt");
        int auth = (Integer)this.get("dns_auth_cnt");
        int add = (Integer)this.get("dns_add_cnt");
        return ans + auth + add;
    }
}

