/*
 * Decompiled with CFR 0.152.
 */
package org.ndx.model.pcap;

import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class BitConverter {
    public static long convertInt(byte[] data) {
        return BitConverter.convertInt(data, false);
    }

    public static long convertInt(byte[] data, boolean reversed) {
        if (!reversed) {
            return (data[3] & 0xFF) << 24 | (data[2] & 0xFF) << 16 | (data[1] & 0xFF) << 8 | data[0] & 0xFF;
        }
        return (data[0] & 0xFF) << 24 | (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
    }

    public static long convertInt(byte[] data, int offset, boolean reversed) {
        byte[] target = new byte[4];
        System.arraycopy(data, offset, target, 0, target.length);
        return BitConverter.convertInt(target, reversed);
    }

    public static long convertInt(byte[] data, int offset) {
        byte[] target = new byte[4];
        System.arraycopy(data, offset, target, 0, target.length);
        return BitConverter.convertInt(target, false);
    }

    public static int convertShort(byte[] data) {
        return (data[0] & 0xFF) << 8 | data[1] & 0xFF;
    }

    public static byte[] convertShort(int data) {
        byte[] result = new byte[]{(byte)(data >> 8), (byte)data};
        return result;
    }

    public static int convertShort(byte[] data, int offset) {
        byte[] target = new byte[2];
        System.arraycopy(data, offset, target, 0, target.length);
        return BitConverter.convertShort(target);
    }

    public static long convertUnsignedInt(byte[] data, int offset) {
        byte[] target = new byte[4];
        System.arraycopy(data, offset, target, 0, target.length);
        BigInteger placeholder = new BigInteger(1, target);
        return placeholder.longValue();
    }

    public static String convertAddress(byte[] data, int offset, int size) {
        byte[] addr = new byte[size];
        System.arraycopy(data, offset, addr, 0, addr.length);
        try {
            return InetAddress.getByAddress(addr).getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
    }
}

