/*
 * Decompiled with CFR 0.152.
 */
package org.ndx.model.json;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.ndx.model.json.JsonAdapter;

public class JsonSfParser
implements JsonAdapter {
    private JSONObject jsonObject;

    JsonSfParser(String json) {
        String msg = "Malformed JSON packet.";
        try {
            this.jsonObject = JSONObject.fromObject(json);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(msg, e);
        }
        if (this.jsonObject.isNullObject()) {
            throw new IllegalArgumentException(msg);
        }
    }

    private JsonSfParser(JSONObject json) {
        this.jsonObject = json;
    }

    @Override
    public JsonAdapter getLayer(String key) {
        try {
            JSONObject temp = this.jsonObject.getJSONObject(key);
            return new JsonSfParser(temp);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Missing " + key + " layer", e);
        }
    }

    @Override
    public int getIntValue(String key) {
        return (Integer)this.getValue(x -> Integer.decode((String)this.jsonObject.get((String)x)), key);
    }

    @Override
    public long getLongValue(String key) {
        return (Long)this.getValue(x -> Long.decode((String)this.jsonObject.get((String)x)), key);
    }

    @Override
    public boolean getBoolValue(String key) {
        return (Boolean)this.getValue(x -> {
            String val = (String)this.jsonObject.get((String)x);
            if ("0".equals(val)) {
                return false;
            }
            if ("1".equals(val)) {
                return true;
            }
            throw new IllegalArgumentException();
        }, key);
    }

    @Override
    public String getStringValue(String key) {
        return (String)this.getValue(x -> this.jsonObject.getString((String)x), key);
    }

    @Override
    public ArrayList<String> getStringArray(String key) {
        try {
            return Arrays.stream(this.jsonObject.getJSONArray(key).toArray()).filter(x -> x instanceof String).map(x -> (String)x).collect(Collectors.toCollection(ArrayList::new));
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Missing string array values - " + key, e);
        }
    }

    @Override
    public ArrayList<JsonAdapter> getLayersArray(String key) {
        try {
            return Arrays.stream(this.jsonObject.getJSONArray(key).toArray()).filter(x -> x instanceof JSONObject).map(x -> new JsonSfParser((JSONObject)x)).collect(Collectors.toCollection(ArrayList::new));
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Missing adapter array values - " + key, e);
        }
    }

    @Override
    public boolean isArray(String key) {
        try {
            this.jsonObject.getJSONArray(key);
            return true;
        }
        catch (JSONException e) {
            return false;
        }
    }

    @Override
    public boolean isString(String key) {
        try {
            return this.jsonObject.get(key) instanceof String;
        }
        catch (JSONException e) {
            return false;
        }
    }

    @Override
    public boolean containsKey(String key) {
        return this.jsonObject.containsKey(key);
    }

    private Object getValue(Function<String, Object> func, String key) {
        try {
            return func.apply(key);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Missing value - " + key, e);
        }
    }
}

