/*
 * Decompiled with CFR 0.152.
 */
package org.ndx.model.json;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Stream;
import org.apache.commons.lang.NotImplementedException;
import org.ndx.model.Packet;
import org.ndx.model.json.JsonAdapter;
import org.ndx.model.json.JsonHelper;
import org.ndx.model.json.JsonSfParser;
import org.ndx.model.parsers.applayer.AppLayerParser;
import org.ndx.model.parsers.applayer.DnsJsonParser;
import org.ndx.model.parsers.applayer.HttpJsonParser;
import org.ndx.model.parsers.applayer.SslHelper;
import org.ndx.model.parsers.applayer.SslJsonParser;

public class JsonPacket
extends Packet {
    private static final String JSON_LAYERS = "layers";
    private static final String JSON_TIMESTAMP = "timestamp";
    private static final String JSON_FRAME = "frame";
    private static final String JSON_FRAME_NUMBER = "frame_frame_number";
    private static final String JSON_FRAME_LENGTH = "frame_frame_len";
    private static final String JSON_IPV4 = "ip";
    private static final String JSON_IPV4_SRC = "ip_ip_src";
    private static final String JSON_IPV4_DST = "ip_ip_dst";
    private static final String JSON_IPV4_HEADER_LEN = "ip_ip_hdr_len";
    private static final String JSON_IPV4_TTL = "ip_ip_ttl";
    private static final String JSON_IPV4_FLAG_DF = "ip_flags_ip_flags_df";
    private static final String JSON_IPV4_FLAG_MF = "ip_flags_ip_flags_mf";
    private static final String JSON_IPV4_FRAGMENT_OFFSET = "ip_ip_frag_offset";
    private static final String JSON_IPV4_ID = "ip_ip_id";
    private static final String JSON_IPV4_PROTOCOL = "ip_ip_proto";
    private static final String JSON_IPV6 = "ipv6";
    private static final String JSON_IPV6_SRC = "ipv6_ipv6_src";
    private static final String JSON_IPV6_DST = "ipv6_ipv6_dst";
    private static final String JSON_IPV6_HOP_LIMIT = "ipv6_ipv6_hlim";
    private static final String JSON_IPV6_FRAGMENT_HEADER = "ipv6_ipv6_fraghdr";
    private static final String JSON_UDP = "udp";
    private static final String JSON_UDP_SRC_PORT = "udp_udp_srcport";
    private static final String JSON_UDP_DST_PORT = "udp_udp_dstport";
    private static final String JSON_UDP_CHECKSUM = "udp_udp_checksum";
    private static final String JSON_UDP_LEN = "udp_udp_length";
    private static final String JSON_TCP_SRC_PORT = "tcp_tcp_srcport";
    private static final String JSON_TCP_DST_PORT = "tcp_tcp_dstport";
    private static final String JSON_TCP = "tcp";
    private static final String JSON_TCP_HEADER_LEN = "tcp_tcp_hdr_len";
    private static final String JSON_TCP_SEQ = "tcp_tcp_seq";
    private static final String JSON_TCP_ACK = "tcp_tcp_ack";
    private static final String JSON_TCP_FLAG_NS = "tcp_flags_tcp_flags_ns";
    private static final String JSON_TCP_FLAG_CWR = "tcp_flags_tcp_flags_cwr";
    private static final String JSON_TCP_FLAG_ECE = "tcp_flags_tcp_flags_ecn";
    private static final String JSON_TCP_FLAG_URG = "tcp_flags_tcp_flags_urg";
    private static final String JSON_TCP_FLAG_ACK = "tcp_flags_tcp_flags_ack";
    private static final String JSON_TCP_FLAG_PSH = "tcp_flags_tcp_flags_push";
    private static final String JSON_TCP_FLAG_RST = "tcp_flags_tcp_flags_reset";
    private static final String JSON_TCP_FLAG_SYN = "tcp_flags_tcp_flags_syn";
    private static final String JSON_TCP_FLAG_FIN = "tcp_flags_tcp_flags_fin";
    private static final String JSON_TCP_PAYLOAD = "tcp_tcp_payload";
    private static final String JSON_TCP_PAYLOAD_LEN = "tcp_tcp_len";
    private static final int IPV4 = 4;
    private static final int IPV6 = 6;

    @Override
    public void parsePacket(String jsonFrame) {
        try {
            JsonSfParser json = new JsonSfParser(jsonFrame);
            JsonAdapter layers = json.getLayer(JSON_LAYERS);
            this.parseFrameLayer(layers.getLayer(JSON_FRAME));
            JsonHelper.addValue((Integer)this.get("number"), this, "ts", json, JSON_TIMESTAMP, JsonHelper.ValueTypes.LONG);
            this.parseIpLayer(layers);
            if (((Boolean)this.get("fragment")).booleanValue()) {
                LOG.info(JsonPacket.getLogPrefix((Integer)this.get("number")) + "IP fragment detected - fragmented packets are not supported.");
            } else {
                this.parseTransportLayer(layers);
                this.parseApplicationLayer(layers);
            }
        }
        catch (IllegalArgumentException e) {
            LOG.warn(JsonPacket.getLogPrefix((Integer)this.get("number")) + e.getMessage());
        }
        catch (NotImplementedException e) {
            LOG.info(JsonPacket.getLogPrefix((Integer)this.get("number")) + e.getMessage());
        }
    }

    private void parseFrameLayer(JsonAdapter frame) {
        JsonHelper.addValue(0, this, "number", frame, JSON_FRAME_NUMBER, JsonHelper.ValueTypes.INT);
        JsonHelper.addValue((Integer)this.get("number"), this, "frame_len", frame, JSON_FRAME_LENGTH, JsonHelper.ValueTypes.INT);
    }

    private void parseIpLayer(JsonAdapter layers) {
        if (layers.containsKey(JSON_IPV4)) {
            this.parseIpV4(layers.getLayer(JSON_IPV4));
        } else if (layers.containsKey(JSON_IPV6)) {
            this.parseIpV6(layers.getLayer(JSON_IPV6));
        } else {
            throw new NotImplementedException("Not supported network layer protocol.");
        }
    }

    private void parseTransportLayer(JsonAdapter layers) {
        if (layers.containsKey("TCP".toLowerCase())) {
            this.parseTcp(layers.getLayer(JSON_TCP));
            this.put("protocol", "TCP");
        } else if (layers.containsKey("UDP".toLowerCase())) {
            this.parseUdp(layers.getLayer(JSON_UDP));
            this.put("protocol", "UDP");
        } else {
            if (layers.containsKey("ICMP".toLowerCase())) {
                this.put("protocol", "ICMP");
            }
            throw new NotImplementedException("Not supported transport layer protocol.");
        }
    }

    private void parseApplicationLayer(JsonAdapter layers) {
        Packet.AppLayerProtocols appProtocol = this.detectAppProtocol(layers);
        this.put("app_protocol", appProtocol);
        if (appProtocol == Packet.AppLayerProtocols.UNKNOWN) {
            return;
        }
        AppLayerParser parser = null;
        Integer number = (Integer)this.get("number");
        String protocol = appProtocol.name().toLowerCase();
        switch (appProtocol) {
            case DNS: {
                DnsJsonParser dnsParser = new DnsJsonParser(number);
                dnsParser.parse(layers.getLayer(protocol));
                parser = dnsParser;
                break;
            }
            case HTTP: {
                HttpJsonParser httpParser = new HttpJsonParser(number);
                httpParser.parse(layers.getLayer(protocol));
                parser = httpParser;
                break;
            }
            case SSL: {
                this.parseSsl(layers);
                break;
            }
            case SMTP: 
            case POP3: 
            case IMAP: {
                break;
            }
            default: {
                LOG.info(JsonPacket.getLogPrefix((Integer)this.get("number")) + "Not supported application layer protocol.");
            }
        }
        if (parser != null) {
            this.putAll(parser);
        }
    }

    private void parseSsl(JsonAdapter layers) {
        String protocol = Packet.AppLayerProtocols.SSL.name().toLowerCase();
        Packet.ProtocolsOverSsl sslProtocol = SslHelper.detectSslProtocol((Integer)this.get("src_port"), (Integer)this.get("dst_port"));
        if (sslProtocol != Packet.ProtocolsOverSsl.UNKNOWN) {
            this.put("app_protocol", Packet.AppLayerProtocols.SSL);
            this.put("ssl_protocol", sslProtocol);
        }
        ArrayList<Object> payloads = new ArrayList<JsonAdapter>();
        HashMap<String, ArrayList> records = new HashMap<String, ArrayList>();
        if (layers.isString(protocol)) {
            return;
        }
        if (layers.isArray(protocol)) {
            payloads = layers.getLayersArray(protocol);
        } else {
            payloads.add(layers.getLayer(protocol));
        }
        for (JsonAdapter jsonAdapter : payloads) {
            SslJsonParser sslParser = new SslJsonParser((Integer)this.get("number"));
            this.mergeSslRecords(records, sslParser.parse(jsonAdapter));
        }
        this.putAll(records);
    }

    private void mergeSslRecords(HashMap<String, ArrayList> record1, HashMap<String, ArrayList> record2) {
        record2.forEach((k, v) -> record1.merge((String)k, (ArrayList)v, (v1, v2) -> {
            v1.addAll(v2);
            return v1;
        }));
    }

    private Packet.AppLayerProtocols detectAppProtocol(JsonAdapter layers) {
        return Stream.of(Packet.AppLayerProtocols.values()).filter(x -> x != Packet.AppLayerProtocols.UNKNOWN).filter(x -> layers.containsKey(x.name().toLowerCase())).findFirst().orElse(Packet.AppLayerProtocols.UNKNOWN);
    }

    private void parseUdp(JsonAdapter udp) {
        Integer number = (Integer)this.get("number");
        JsonHelper.addValue(number, this, "src_port", udp, JSON_UDP_SRC_PORT, JsonHelper.ValueTypes.INT);
        JsonHelper.addValue(number, this, "dst_port", udp, JSON_UDP_DST_PORT, JsonHelper.ValueTypes.INT);
        JsonHelper.addValue(number, this, "udpsum", udp, JSON_UDP_CHECKSUM, JsonHelper.ValueTypes.INT);
        if ((Integer)this.get("udpsum") == 0) {
            this.remove("udpsum");
        }
        try {
            int udpLen = udp.getIntValue(JSON_UDP_LEN);
            this.put("udp_length", udpLen - 8);
            this.put("payload_len", udpLen - 8);
            this.put("len", udpLen - 8);
        }
        catch (IllegalArgumentException e) {
            LOG.warn(JsonPacket.getLogPrefix((Integer)this.get("number")) + "Missing value - " + "payload_len");
        }
    }

    private void parseTcp(JsonAdapter tcp) {
        String payload;
        Integer number = (Integer)this.get("number");
        JsonHelper.addValue(number, this, "src_port", tcp, JSON_TCP_SRC_PORT, JsonHelper.ValueTypes.INT);
        JsonHelper.addValue(number, this, "dst_port", tcp, JSON_TCP_DST_PORT, JsonHelper.ValueTypes.INT);
        JsonHelper.addValue(number, this, "tcp_header_length", tcp, JSON_TCP_HEADER_LEN, JsonHelper.ValueTypes.INT);
        JsonHelper.addValue(number, this, "tcp_seq", tcp, JSON_TCP_SEQ, JsonHelper.ValueTypes.LONG);
        JsonHelper.addValue(number, this, "tcp_ack", tcp, JSON_TCP_ACK, JsonHelper.ValueTypes.LONG);
        JsonHelper.addValue(number, this, "payload_len", tcp, JSON_TCP_PAYLOAD_LEN, JsonHelper.ValueTypes.INT);
        JsonHelper.addValue(number, this, "len", tcp, JSON_TCP_PAYLOAD_LEN, JsonHelper.ValueTypes.INT);
        try {
            payload = tcp.getStringValue(JSON_TCP_PAYLOAD);
        }
        catch (IllegalArgumentException e) {
            payload = "";
        }
        this.put("tcp_payload", payload.replace(":", ""));
        JsonHelper.addValue(number, this, "tcp_flag_ns", tcp, JSON_TCP_FLAG_NS, JsonHelper.ValueTypes.BOOLEAN);
        JsonHelper.addValue(number, this, "tcp_flag_cwr", tcp, JSON_TCP_FLAG_CWR, JsonHelper.ValueTypes.BOOLEAN);
        JsonHelper.addValue(number, this, "tcp_flag_ece", tcp, JSON_TCP_FLAG_ECE, JsonHelper.ValueTypes.BOOLEAN);
        JsonHelper.addValue(number, this, "tcp_flag_urg", tcp, JSON_TCP_FLAG_URG, JsonHelper.ValueTypes.BOOLEAN);
        JsonHelper.addValue(number, this, "tcp_flag_ack", tcp, JSON_TCP_FLAG_ACK, JsonHelper.ValueTypes.BOOLEAN);
        JsonHelper.addValue(number, this, "tcp_flag_psh", tcp, JSON_TCP_FLAG_PSH, JsonHelper.ValueTypes.BOOLEAN);
        JsonHelper.addValue(number, this, "tcp_flag_rst", tcp, JSON_TCP_FLAG_RST, JsonHelper.ValueTypes.BOOLEAN);
        JsonHelper.addValue(number, this, "tcp_flag_syn", tcp, JSON_TCP_FLAG_SYN, JsonHelper.ValueTypes.BOOLEAN);
        JsonHelper.addValue(number, this, "tcp_flag_fin", tcp, JSON_TCP_FLAG_FIN, JsonHelper.ValueTypes.BOOLEAN);
    }

    private void parseIpV4(JsonAdapter ipV4) {
        this.put("ip_version", 4);
        Integer number = (Integer)this.get("number");
        JsonHelper.addValue(number, this, "ip_header_length", ipV4, JSON_IPV4_HEADER_LEN, JsonHelper.ValueTypes.INT);
        JsonHelper.addValue(number, this, "src", ipV4, JSON_IPV4_SRC, JsonHelper.ValueTypes.STRING);
        JsonHelper.addValue(number, this, "dst", ipV4, JSON_IPV4_DST, JsonHelper.ValueTypes.STRING);
        JsonHelper.addValue(number, this, "ttl", ipV4, JSON_IPV4_TTL, JsonHelper.ValueTypes.INT);
        JsonHelper.addValue(number, this, "ip_flags_df", ipV4, JSON_IPV4_FLAG_DF, JsonHelper.ValueTypes.BOOLEAN);
        JsonHelper.addValue(number, this, "ip_flags_mf", ipV4, JSON_IPV4_FLAG_MF, JsonHelper.ValueTypes.BOOLEAN);
        JsonHelper.addValue(number, this, "fragment_offset", ipV4, JSON_IPV4_FRAGMENT_OFFSET, JsonHelper.ValueTypes.LONG);
        Boolean flagMf = (Boolean)this.get("ip_flags_mf");
        Long fragOffset = (Long)this.get("fragment_offset");
        this.put("fragment", false);
        if (flagMf != null && fragOffset != null && (flagMf.booleanValue() || fragOffset > 0L)) {
            this.put("fragment", true);
            this.put("last_fragment", flagMf == false);
        }
        JsonHelper.addValue(number, this, "id", ipV4, JSON_IPV4_ID, JsonHelper.ValueTypes.LONG);
        JsonHelper.addValue(number, this, "protocol", ipV4, JSON_IPV4_PROTOCOL, JsonHelper.ValueTypes.STRING);
    }

    private void parseIpV6(JsonAdapter ipV6) {
        this.put("ip_version", 6);
        Integer number = (Integer)this.get("number");
        JsonHelper.addValue(number, this, "src", ipV6, JSON_IPV6_SRC, JsonHelper.ValueTypes.STRING);
        JsonHelper.addValue(number, this, "dst", ipV6, JSON_IPV6_DST, JsonHelper.ValueTypes.STRING);
        JsonHelper.addValue(number, this, "ttl", ipV6, JSON_IPV6_HOP_LIMIT, JsonHelper.ValueTypes.INT);
        if (ipV6.containsKey(JSON_IPV6_FRAGMENT_HEADER)) {
            this.put("fragment", true);
        } else {
            this.put("fragment", false);
            this.put("protocol", "Fragment");
        }
    }
}

