/*
 * Decompiled with CFR 0.152.
 */
package org.ndx.tshark.java;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.PairFunction;
import org.ndx.model.Packet;
import org.ndx.model.Statistics;
import org.ndx.model.pcap.ConversationModel;
import org.ndx.tshark.java.TShark;
import scala.Tuple2;

public class TSharkTests {
    public static JavaPairRDD<String, ConversationModel.FlowAttributes> testFlows(JavaSparkContext sc, String path) {
        JavaRDD<Packet> packets = TShark.getPackets(sc, path);
        if (packets == null) {
            return null;
        }
        JavaPairRDD flows = packets.mapToPair((PairFunction & Serializable)x -> new Tuple2((Object)x.getFlowString(), x));
        return flows.mapToPair((PairFunction & Serializable)x -> new Tuple2(x._1, (Object)Statistics.fromPacket((Packet)((Packet)x._2)))).reduceByKey(Statistics::merge);
    }

    public static void testPacketInfo(JavaSparkContext sc, String path) {
        JavaRDD<Packet> packets = TShark.getPackets(sc, path);
        if (packets == null) {
            return;
        }
        ConversationModel.FlowAttributes capinfo = (ConversationModel.FlowAttributes)packets.map(Statistics::fromPacket).reduce(Statistics::merge);
        System.out.println("Json: no of packets: " + capinfo.getPackets());
        System.out.println("Json: First packet time: " + Statistics.ticksToDate((long)capinfo.getFirstSeen()));
        System.out.println("Json: Last packet time: " + Statistics.ticksToDate((long)capinfo.getLastSeen()));
        System.out.println("Json: Data byte rate: " + (double)capinfo.getOctets() / Statistics.timestampToSeconds((long)(capinfo.getLastSeen() - capinfo.getFirstSeen())));
        System.out.println("Json: Data bit rate " + (double)capinfo.getOctets() / Statistics.timestampToSeconds((long)(capinfo.getLastSeen() - capinfo.getFirstSeen())) * 8.0);
        System.out.println("Json: Average packet size: " + capinfo.getMeanPayloadSize());
        System.out.println("Json: Average packet rate: " + (double)capinfo.getPackets() / Statistics.timestampToSeconds((long)(capinfo.getLastSeen() - capinfo.getFirstSeen())));
    }

    public static void testHttpData(JavaSparkContext sc, String path) {
        JavaRDD<Packet> packets = TShark.getPackets(sc, path);
        if (packets == null) {
            return;
        }
        packets.collect().forEach(x -> {
            if (x.get((Object)"app_protocol") != Packet.AppLayerProtocols.HTTP) {
                return;
            }
            System.out.println("Packet number: " + x.get((Object)"number"));
            boolean isResponse = (Boolean)x.get((Object)"http_is_response");
            if (isResponse) {
                System.out.println("Req/Res: Response");
            } else {
                System.out.println("Req/Res: Request");
                System.out.println("URL: " + x.get((Object)"http_url"));
                System.out.println("Method: " + x.get((Object)"http_method"));
            }
            System.out.println("Version: " + x.get((Object)"http_version"));
            System.out.println();
        });
    }

    public static void testTcpPayload(JavaSparkContext sc, String path) {
        JavaRDD<Packet> packets = TShark.getPackets(sc, path);
        if (packets == null) {
            return;
        }
        packets.collect().forEach(x -> {
            if (!x.get((Object)"protocol").equals("TCP")) {
                return;
            }
            System.out.println("Packet number: " + x.get((Object)"number"));
            String payload = (String)x.get((Object)"tcp_payload");
            if (payload != null) {
                System.out.println(payload);
            }
            System.out.println();
        });
    }

    public static void testIpv6Packets(JavaSparkContext sc, String path) {
        JavaRDD<Packet> packets = TShark.getPackets(sc, path);
        if (packets == null) {
            return;
        }
        packets.collect().forEach(x -> {
            if ((Integer)x.get((Object)"ip_version") != 6) {
                return;
            }
            System.out.println("Packet number: " + x.get((Object)"number"));
            String protocol = (String)x.get((Object)"protocol");
            System.out.println("Protocol: " + protocol);
            if (((Boolean)x.get((Object)"fragment")).booleanValue()) {
                System.out.println("Fragmented.");
            } else {
                System.out.println("Not fragmented.");
            }
            System.out.println();
        });
    }

    public static void testDnsData(JavaSparkContext sc, String path) {
        JavaRDD<Packet> packets = TShark.getPackets(sc, path);
        if (packets == null) {
            return;
        }
        packets.collect().forEach(x -> {
            if (x.get((Object)"app_protocol") != Packet.AppLayerProtocols.DNS) {
                return;
            }
            System.out.println("Packet number: " + x.get((Object)"number"));
            String qOrR = "Query";
            if (((Boolean)x.get((Object)"dns_query_response")).booleanValue()) {
                qOrR = "Response";
            }
            System.out.println("Q/R: " + qOrR);
            System.out.println("ID: " + x.get((Object)"dns_id"));
            System.out.println("Query cnt: " + x.get((Object)"dns_query_cnt"));
            System.out.println("Answer cnt: " + x.get((Object)"dns_answer_cnt"));
            ArrayList queries = (ArrayList)x.get((Object)"dns_queries");
            ArrayList answers = (ArrayList)x.get((Object)"dns_answers");
            for (String q : queries) {
                System.out.println(q);
            }
            for (String a : answers) {
                System.out.println(a);
            }
            System.out.println();
        });
    }

    public static void testAppProtocols(JavaSparkContext sc, String path) {
        JavaRDD<Packet> packets = TShark.getPackets(sc, path);
        if (packets == null) {
            return;
        }
        packets.collect().forEach(x -> {
            Packet.AppLayerProtocols protocol = (Packet.AppLayerProtocols)x.get((Object)"app_protocol");
            Integer no = (Integer)x.get((Object)"number");
            if (protocol == null || no == null) {
                return;
            }
            System.out.println("Packet " + no + ": " + protocol.name());
            System.out.println();
        });
    }
}

