/*
 * Decompiled with CFR 0.152.
 */
package org.ndx.model.parsers.applayer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.impl.io.DefaultHttpRequestParser;
import org.apache.http.impl.io.DefaultHttpResponseParser;
import org.apache.http.impl.io.HttpTransportMetricsImpl;
import org.apache.http.impl.io.SessionInputBufferImpl;
import org.apache.http.io.SessionInputBuffer;
import org.ndx.model.parsers.applayer.AppLayerParser;

public class HttpPcapParser
extends AppLayerParser {
    private static final String HTTP_PCAP_HOST = "Host";

    public void parse(byte[] payload) {
        try {
            this.tryParsePcapHttpRequest(payload);
        }
        catch (IOException | IllegalArgumentException | HttpException e) {
            try {
                this.tryParsePcapHttpResponse(payload);
            }
            catch (IOException | IllegalArgumentException | HttpException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
    }

    private void tryParsePcapHttpRequest(byte[] payload) throws IOException, HttpException {
        SessionInputBufferImpl buffer = this.getSessionBuffer(payload);
        DefaultHttpRequestParser requestParser = new DefaultHttpRequestParser((SessionInputBuffer)buffer);
        HttpRequest request = (HttpRequest)requestParser.parse();
        this.put("http_version", this.getProtocolVersion(request.getRequestLine().getProtocolVersion()));
        this.put("http_is_response", false);
        this.put("http_method", request.getRequestLine().getMethod());
        Header[] headers = request.getAllHeaders();
        String host = "";
        for (Header header : headers) {
            if (!header.getName().equals(HTTP_PCAP_HOST)) continue;
            host = header.getValue();
        }
        this.put("http_url", host);
    }

    private void tryParsePcapHttpResponse(byte[] payload) throws IOException, HttpException {
        SessionInputBufferImpl buffer = this.getSessionBuffer(payload);
        DefaultHttpResponseParser responseParser = new DefaultHttpResponseParser((SessionInputBuffer)buffer);
        HttpResponse response = (HttpResponse)responseParser.parse();
        this.put("http_version", this.getProtocolVersion(response.getProtocolVersion()));
        this.put("http_is_response", true);
    }

    private SessionInputBufferImpl getSessionBuffer(byte[] payload) {
        ByteArrayInputStream stream = new ByteArrayInputStream(payload);
        HttpTransportMetricsImpl metrics = new HttpTransportMetricsImpl();
        SessionInputBufferImpl buffer = new SessionInputBufferImpl(metrics, payload.length);
        buffer.bind((InputStream)stream);
        return buffer;
    }

    private String getProtocolVersion(ProtocolVersion pVersion) {
        int major = pVersion.getMajor();
        int minor = pVersion.getMinor();
        return pVersion.getProtocol() + "/" + Integer.toString(major) + "." + Integer.toString(minor);
    }
}

