/*
 * Decompiled with CFR 0.152.
 */
package org.ndx.tshark.scala;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.SparkSession;
import org.ndx.model.Packet;
import org.ndx.model.Statistics;
import org.ndx.model.json.JsonPacket;
import org.ndx.model.parsers.applayer.HttpHelper;
import org.ndx.model.pcap.ConversationModel;
import org.ndx.model.pcap.FlowModel;
import org.ndx.model.pcap.PacketModel;
import org.ndx.model.pcap.PcapPacket;
import org.ndx.pcap.PcapInputFormat;
import org.ndx.tshark.scala.CipherSuite;
import org.ndx.tshark.scala.DnsData;
import org.ndx.tshark.scala.DnsDataRaw;
import org.ndx.tshark.scala.DnsLatency;
import org.ndx.tshark.scala.FlowStatistics;
import org.ndx.tshark.scala.Keyword;
import org.ndx.tshark.scala.TShark;
import org.ndx.tshark.scala.TShark$;
import org.ndx.tshark.scala.TcpPacket;
import org.ndx.tshark.scala.Url;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class TShark$ {
    public static final TShark$ MODULE$;
    private final Log Log;
    private final String Pcap;
    private final String Cap;
    private final String Json;

    static {
        new TShark$();
    }

    private Log Log() {
        return this.Log;
    }

    private String Pcap() {
        return this.Pcap;
    }

    private String Cap() {
        return this.Cap;
    }

    private String Json() {
        return this.Json;
    }

    public RDD<Tuple2<String, Iterable<Packet>>> getFlows(RDD<Packet> packets) {
        if (this.isNull((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{packets}))) {
            return null;
        }
        return RDD$.MODULE$.rddToPairRDDFunctions(packets.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Packet> apply(Packet x) {
                return new Tuple2((Object)x.getFlowString(), (Object)x);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Packet.class), (Ordering)Ordering.String$.MODULE$).groupByKey();
    }

    public RDD<FlowStatistics> getFlowStatistics(RDD<Packet> packets) {
        if (this.isNull((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{packets}))) {
            return null;
        }
        RDD stats = RDD$.MODULE$.rddToPairRDDFunctions(packets.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Packet x) {
                Object protocol = Option$.MODULE$.apply(x.get("protocol")).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                });
                return (protocol.equals("TCP") || protocol.equals("UDP")) && !BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply(x.get("fragment")).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return true;
                    }
                }));
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Packet> apply(Packet x) {
                return new Tuple2((Object)x.getFlowString(), (Object)x);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, ConversationModel.FlowAttributes> apply(Tuple2<String, Packet> x) {
                return new Tuple2(x._1(), (Object)Statistics.fromPacket((Packet)x._2()));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(ConversationModel.FlowAttributes.class), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ConversationModel.FlowAttributes apply(ConversationModel.FlowAttributes acc, ConversationModel.FlowAttributes stats) {
                return Statistics.merge(acc, stats);
            }
        });
        return stats.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final FlowStatistics apply(Tuple2<String, ConversationModel.FlowAttributes> x) {
                FlowModel.FlowKey flowKey = Packet.flowKeyParse((String)x._1());
                String srcAddr = flowKey.getSourceAddress().toStringUtf8();
                String destAddr = flowKey.getDestinationAddress().toStringUtf8();
                String srcPort = flowKey.getSourceSelector().toStringUtf8();
                String destPort = flowKey.getDestinationSelector().toStringUtf8();
                return new FlowStatistics(new Timestamp(Statistics.ticksToDate(((ConversationModel.FlowAttributes)x._2()).getFirstSeen()).getTime()), new Timestamp(Statistics.ticksToDate(((ConversationModel.FlowAttributes)x._2()).getLastSeen()).getTime()), flowKey.getProtocol().toStringUtf8(), srcAddr, srcPort, destAddr, destPort, Statistics.getService(flowKey.getSourceSelector().toStringUtf8(), flowKey.getDestinationSelector().toStringUtf8()), Statistics.getDirection(flowKey.getSourceSelector().toStringUtf8(), flowKey.getDestinationSelector().toStringUtf8()), Predef$.MODULE$.int2Integer(((ConversationModel.FlowAttributes)x._2()).getPackets()), ((ConversationModel.FlowAttributes)x._2()).getOctets(), Statistics.lanOrWan(srcAddr, destAddr), Statistics.getEmailProtocol(srcPort, destPort));
            }
        }, ClassTag$.MODULE$.apply(FlowStatistics.class));
    }

    public void registerFlowStatistics(String viewName, RDD<Packet> packets, SparkSession spark) {
        if (this.isNull((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{viewName, packets, spark}))) {
            return;
        }
        RDD<FlowStatistics> stats = this.getFlowStatistics(packets);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_ndx_tshark_scala_TShark$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.ndx.tshark.scala.FlowStatistics").asType().toTypeConstructor();
            }

            public Org_ndx_tshark_scala_TShark$$typecreator3$1() {
            }
        }
        spark.implicits().rddToDatasetHolder(stats, spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_ndx_tshark_scala_TShark$$typecreator3$1()))).toDF().createOrReplaceTempView(viewName);
    }

    public RDD<Url> getHttpHostnames(RDD<Packet> packets) {
        if (this.isNull((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{packets}))) {
            return null;
        }
        return packets.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Packet x) {
                return Option$.MODULE$.apply(x.get("http_url")).isDefined();
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Url apply(Packet packet) {
                return new Url(HttpHelper.getHostFromUrl((String)packet.get("http_url")));
            }
        }, ClassTag$.MODULE$.apply(Url.class));
    }

    public void registerHttpHostnames(String viewName, RDD<Packet> packets, SparkSession spark) {
        if (this.isNull((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{viewName, packets, spark}))) {
            return;
        }
        RDD<Url> urls = this.getHttpHostnames(packets);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_ndx_tshark_scala_TShark$$typecreator7$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.ndx.tshark.scala.Url").asType().toTypeConstructor();
            }

            public Org_ndx_tshark_scala_TShark$$typecreator7$1() {
            }
        }
        spark.implicits().rddToDatasetHolder(urls, spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_ndx_tshark_scala_TShark$$typecreator7$1()))).toDF().createOrReplaceTempView(viewName);
    }

    public RDD<DnsDataRaw> getDnsData(RDD<Packet> packets) {
        if (this.isNull((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{packets}))) {
            return null;
        }
        return this.getDnsPackets(packets).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Packet x) {
                return x.containsKey("dns_id") && x.containsKey("dns_query_response");
            }
        }).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TraversableOnce<DnsDataRaw> apply(Packet x) {
                String flow = x.getFlowString();
                Integer id = (Integer)x.get("dns_id");
                boolean isResponse = BoxesRunTime.unboxToBoolean(x.get("dns_query_response"));
                Seq records = isResponse ? JavaConversions$.MODULE$.asScalaBuffer((java.util.List)((ArrayList)x.get("dns_answers"))).toSeq() : JavaConversions$.MODULE$.asScalaBuffer((java.util.List)((ArrayList)x.get("dns_queries"))).toSeq();
                Object object = records.isEmpty() ? BoxesRunTime.boxToBoolean((boolean)JavaConversions$.MODULE$.seqAsJavaList(records).add("")) : BoxedUnit.UNIT;
                return (TraversableOnce)records.map((Function1)new Serializable(this, flow, id, isResponse){
                    public static final long serialVersionUID = 0L;
                    private final String flow$1;
                    private final Integer id$1;
                    private final boolean isResponse$1;

                    public final DnsDataRaw apply(String record) {
                        return new DnsDataRaw(this.flow$1, this.id$1, this.isResponse$1, record);
                    }
                    {
                        this.flow$1 = flow$1;
                        this.id$1 = id$1;
                        this.isResponse$1 = isResponse$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        }, ClassTag$.MODULE$.apply(DnsDataRaw.class));
    }

    public void registerDnsData(String viewName, RDD<Packet> packets, SparkSession spark) {
        if (this.isNull((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{viewName, packets, spark}))) {
            return;
        }
        RDD dnsData = this.getDnsData(packets).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DnsData apply(DnsDataRaw x) {
                String[] splits = x.record().split(",");
                return new DnsData(x.flow(), x.id(), x.isResponse(), (String)((Option)Predef$.MODULE$.wrapRefArray((Object[])splits).lift().apply((Object)BoxesRunTime.boxToInteger((int)0))).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                }), (String)((Option)Predef$.MODULE$.wrapRefArray((Object[])splits).lift().apply((Object)BoxesRunTime.boxToInteger((int)1))).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                }), (String)((Option)Predef$.MODULE$.wrapRefArray((Object[])splits).lift().apply((Object)BoxesRunTime.boxToInteger((int)2))).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                }), (String)((Option)Predef$.MODULE$.wrapRefArray((Object[])splits).lift().apply((Object)BoxesRunTime.boxToInteger((int)3))).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                }));
            }
        }, ClassTag$.MODULE$.apply(DnsData.class));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_ndx_tshark_scala_TShark$$typecreator11$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.ndx.tshark.scala.DnsData").asType().toTypeConstructor();
            }

            public Org_ndx_tshark_scala_TShark$$typecreator11$1() {
            }
        }
        spark.implicits().rddToDatasetHolder(dnsData, spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_ndx_tshark_scala_TShark$$typecreator11$1()))).toDF().createOrReplaceTempView(viewName);
    }

    public RDD<Keyword> getKeywords(RDD<Packet> packets, List<String> keywords, SparkContext sc) {
        if (this.isNull((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{packets, keywords, sc}))) {
            return null;
        }
        java.util.List javaKeywords = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(keywords).asJava();
        scala.collection.mutable.Map keywordsMap = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)packets.map((Function1)new Serializable(javaKeywords){
            public static final long serialVersionUID = 0L;
            private final java.util.List javaKeywords$1;

            public final Map<String, Integer> apply(Packet x) {
                return (Map)Option$.MODULE$.apply(x.findKeyWords(this.javaKeywords$1)).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final HashMap<String, Integer> apply() {
                        return new HashMap<String, Integer>();
                    }
                });
            }
            {
                this.javaKeywords$1 = javaKeywords$1;
            }
        }, ClassTag$.MODULE$.apply(Map.class)).reduce((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Map<String, Integer> apply(Map<String, Integer> x, Map<String, Integer> y) {
                return Statistics.mergeMaps(x, y);
            }
        })).asScala();
        return sc.parallelize(keywordsMap.toSeq(), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Keyword apply(Tuple2<String, Integer> x) {
                return new Keyword((String)x._1(), (Integer)x._2());
            }
        }, ClassTag$.MODULE$.apply(Keyword.class));
    }

    public void registerKeywords(String viewName, RDD<Packet> packets, List<String> keywords, SparkSession spark, SparkContext sc) {
        if (this.isNull((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{viewName, packets, keywords, spark, sc}))) {
            return;
        }
        RDD<Keyword> kws = this.getKeywords(packets, keywords, sc);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_ndx_tshark_scala_TShark$$typecreator15$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.ndx.tshark.scala.Keyword").asType().toTypeConstructor();
            }

            public Org_ndx_tshark_scala_TShark$$typecreator15$1() {
            }
        }
        spark.implicits().rddToDatasetHolder(kws, spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_ndx_tshark_scala_TShark$$typecreator15$1()))).toDF().createOrReplaceTempView(viewName);
    }

    public RDD<CipherSuite> getCipherSuites(RDD<Packet> packets) {
        if (this.isNull((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{packets}))) {
            return null;
        }
        return packets.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Packet x) {
                return x.containsKey("ssl_cipher_suites");
            }
        }).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TraversableOnce<CipherSuite> apply(Packet x) {
                return (TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer((java.util.List)((ArrayList)x.get("ssl_cipher_suites"))).toSeq().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CipherSuite apply(String x) {
                        return new CipherSuite(x);
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        }, ClassTag$.MODULE$.apply(CipherSuite.class));
    }

    public void registerCipherSuites(String viewName, RDD<Packet> packets, SparkSession spark) {
        if (this.isNull((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{viewName, packets, spark}))) {
            return;
        }
        RDD<CipherSuite> cs = this.getCipherSuites(packets);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_ndx_tshark_scala_TShark$$typecreator19$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.ndx.tshark.scala.CipherSuite").asType().toTypeConstructor();
            }

            public Org_ndx_tshark_scala_TShark$$typecreator19$1() {
            }
        }
        spark.implicits().rddToDatasetHolder(cs, spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_ndx_tshark_scala_TShark$$typecreator19$1()))).toDF().createOrReplaceTempView(viewName);
    }

    public RDD<DnsLatency> getDnsLatency(RDD<Packet> packets) {
        if (this.isNull((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{packets}))) {
            return null;
        }
        return RDD$.MODULE$.rddToPairRDDFunctions(this.getDnsPackets(packets).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Packet x) {
                return x.containsKey("dns_id") && x.containsKey("dns_query_response") && x.containsKey("ts") && x.containsKey("src") && x.containsKey("dst") && x.containsKey("dst_port");
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Packet> apply(Packet x) {
                return new Tuple2((Object)new StringBuilder().append((Object)x.getSessionString()).append((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt(x.get("dns_id")))).toString(), (Object)x);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Packet.class), (Ordering)Ordering.String$.MODULE$).groupByKey().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterable<Packet> apply(Tuple2<String, Iterable<Packet>> x) {
                return (Iterable)x._2();
            }
        }, ClassTag$.MODULE$.apply(Iterable.class)).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Iterable<Packet> x) {
                return x.size() == 2;
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Option<Packet>, Option<Packet>> apply(Iterable<Packet> x) {
                return new Tuple2(x.toSeq().lift().apply((Object)BoxesRunTime.boxToInteger((int)0)), x.toSeq().lift().apply((Object)BoxesRunTime.boxToInteger((int)1)));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Option<Packet>, Option<Packet>> x) {
                return BoxesRunTime.unboxToBoolean((Object)JavaConversions$.MODULE$.mapAsScalaMap((Map)((Option)x._1()).get()).apply((Object)"dns_query_response")) ^ BoxesRunTime.unboxToBoolean((Object)JavaConversions$.MODULE$.mapAsScalaMap((Map)((Option)x._2()).get()).apply((Object)"dns_query_response"));
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DnsLatency apply(Tuple2<Option<Packet>, Option<Packet>> x) {
                String address = BoxesRunTime.unboxToBoolean((Object)JavaConversions$.MODULE$.mapAsScalaMap((Map)((Option)x._1()).get()).apply((Object)"dns_query_response")) ? (String)JavaConversions$.MODULE$.mapAsScalaMap((Map)((Option)x._1()).get()).apply((Object)"src") : (String)JavaConversions$.MODULE$.mapAsScalaMap((Map)((Option)x._1()).get()).apply((Object)"dst");
                long latency = Math.abs(BoxesRunTime.unboxToLong((Object)JavaConversions$.MODULE$.mapAsScalaMap((Map)((Option)x._1()).get()).apply((Object)"ts")) - BoxesRunTime.unboxToLong((Object)JavaConversions$.MODULE$.mapAsScalaMap((Map)((Option)x._2()).get()).apply((Object)"ts")));
                return new DnsLatency(address, latency);
            }
        }, ClassTag$.MODULE$.apply(DnsLatency.class));
    }

    public void registerDnsLatency(String viewName, RDD<Packet> packets, SparkSession spark) {
        if (this.isNull((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{viewName, packets, spark}))) {
            return;
        }
        RDD<DnsLatency> lat = this.getDnsLatency(packets);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_ndx_tshark_scala_TShark$$typecreator23$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.ndx.tshark.scala.DnsLatency").asType().toTypeConstructor();
            }

            public Org_ndx_tshark_scala_TShark$$typecreator23$1() {
            }
        }
        spark.implicits().rddToDatasetHolder(lat, spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_ndx_tshark_scala_TShark$$typecreator23$1()))).toDF().createOrReplaceTempView(viewName);
    }

    public RDD<Tuple2<String, Iterable<TcpPacket>>> getTcpFlows(RDD<Packet> packets) {
        if (this.isNull((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{packets}))) {
            return null;
        }
        RDD tcpPackets = packets.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Packet x) {
                return Option$.MODULE$.apply(x.get("protocol")).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                }).equals("TCP") && !BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply(x.get("fragment")).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return true;
                    }
                })) && x.containsKey("ts") && x.containsKey("tcp_flag_ns") && x.containsKey("tcp_flag_cwr") && x.containsKey("tcp_flag_ece") && x.containsKey("tcp_flag_urg") && x.containsKey("tcp_flag_ack") && x.containsKey("tcp_flag_psh") && x.containsKey("tcp_flag_rst") && x.containsKey("tcp_flag_syn") && x.containsKey("tcp_flag_fin") && x.containsKey("tcp_seq");
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TcpPacket apply(Packet x) {
                return new TcpPacket(x.getFlowString(), new Timestamp(BoxesRunTime.unboxToLong(x.get("ts"))), BoxesRunTime.unboxToBoolean(x.get("tcp_flag_ns")), BoxesRunTime.unboxToBoolean(x.get("tcp_flag_cwr")), BoxesRunTime.unboxToBoolean(x.get("tcp_flag_ece")), BoxesRunTime.unboxToBoolean(x.get("tcp_flag_urg")), BoxesRunTime.unboxToBoolean(x.get("tcp_flag_ack")), BoxesRunTime.unboxToBoolean(x.get("tcp_flag_psh")), BoxesRunTime.unboxToBoolean(x.get("tcp_flag_rst")), BoxesRunTime.unboxToBoolean(x.get("tcp_flag_syn")), BoxesRunTime.unboxToBoolean(x.get("tcp_flag_fin")), BoxesRunTime.unboxToLong(x.get("tcp_seq")), (Integer)x.get("frame_len"), (String)Option$.MODULE$.apply(x.get("tcp_payload")).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                }));
            }
        }, ClassTag$.MODULE$.apply(TcpPacket.class));
        return RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(tcpPackets.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, TcpPacket> apply(TcpPacket x) {
                return new Tuple2((Object)x.flow(), (Object)x);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(TcpPacket.class), (Ordering)Ordering.String$.MODULE$).groupByKey(), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Iterable.class), (Ordering)Ordering.String$.MODULE$).mapValues((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<TcpPacket> apply(Iterable<TcpPacket> x$1) {
                return (Seq)x$1.toSeq().sortBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(TcpPacket x$2) {
                        return x$2.timeStamp().getTime();
                    }
                }, (Ordering)Ordering.Long$.MODULE$);
            }
        });
    }

    private RDD<Packet> getDnsPackets(RDD<Packet> packets) {
        return packets.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Packet x) {
                return Option$.MODULE$.apply(x.get("app_protocol")).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                }).equals((Object)((Object)Packet.AppLayerProtocols.DNS));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private boolean isNull(Seq<Object> args) {
        void var2_2;
        boolean isNull;
        boolean bl = isNull = args.count((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Object arg) {
                return arg == null;
            }
        }) != 0;
        if (isNull) {
            this.Log().error("Input params should not be null.");
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public RDD<Packet> getPackets(SparkContext sc, String path) {
        void var3_3;
        RDD<Packet> packets = null;
        try {
            packets = this.readInputFiles(sc, path);
        }
        catch (Exception exception) {
            this.Log().error(exception.getMessage());
        }
        catch (IOException iOException) {
            this.Log().error(iOException.getMessage());
        }
        return var3_3;
    }

    private RDD<Packet> readInputFiles(SparkContext sc, String path) {
        block7: {
            RDD<Packet> rDD;
            block6: {
                String string;
                block5: {
                    boolean bl;
                    string = FilenameUtils.getExtension((String)path);
                    String string2 = this.Pcap();
                    String string3 = string;
                    if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                        bl = true;
                    } else {
                        String string4 = this.Cap();
                        String string5 = string;
                        bl = !(string4 != null ? !string4.equals(string5) : string5 != null);
                    }
                    if (!bl) break block5;
                    rDD = this.pcapToPacket(sc, path);
                    break block6;
                }
                String string6 = this.Json();
                String string7 = string;
                if (string6 != null ? !string6.equals(string7) : string7 != null) break block7;
                rDD = this.jsonToPacket(sc, path);
            }
            return rDD;
        }
        throw new IOException("Not supported input file format.");
    }

    private RDD<Packet> jsonToPacket(SparkContext sc, String path) {
        RDD lines = sc.newAPIHadoopFile(path, TextInputFormat.class, LongWritable.class, Text.class, new Configuration());
        RDD jsons = lines.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<LongWritable, Text> x) {
                return ((Text)x._2()).toString().startsWith("{\"time");
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<LongWritable, Text> x) {
                return ((Text)x._2()).toString();
            }
        }, ClassTag$.MODULE$.apply(String.class));
        return jsons.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             */
            public final Packet apply(String jsonFrame) {
                void var2_2;
                JsonPacket packet = new JsonPacket();
                ((Packet)packet).parsePacket(jsonFrame);
                return var2_2;
            }
        }, ClassTag$.MODULE$.apply(Packet.class));
    }

    private RDD<Packet> pcapToPacket(SparkContext sc, String path) {
        RDD frames = sc.hadoopFile(path, PcapInputFormat.class, LongWritable.class, ObjectWritable.class, sc.hadoopFile$default$5());
        return frames.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             */
            public final PcapPacket apply(Tuple2<LongWritable, ObjectWritable> pcapFrame) {
                void var2_2;
                PcapPacket packet = new PcapPacket();
                packet.parsePacket((PacketModel.RawFrame)((ObjectWritable)pcapFrame._2()).get());
                return var2_2;
            }
        }, ClassTag$.MODULE$.apply(Packet.class));
    }

    private TShark$() {
        MODULE$ = this;
        this.Log = LogFactory.getLog(TShark.class);
        this.Pcap = "pcap";
        this.Cap = "cap";
        this.Json = "json";
    }
}

