/*
 * Decompiled with CFR 0.152.
 */
package org.ndx.pcap;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.ndx.model.pcap.PacketModel;
import org.ndx.pcap.PcapReader;

public class PcapRecordReader
implements RecordReader<LongWritable, ObjectWritable> {
    private PcapReader pcapReader;
    private Iterator<PacketModel.RawFrame> pcapReaderIterator;
    private Seekable baseStream;
    private DataInputStream stream;
    private Reporter reporter;
    private long packetCount = 0L;
    private long start;
    private long end;

    public PcapRecordReader(PcapReader pcapReader, long start, long end, Seekable baseStream, DataInputStream stream, Reporter reporter) {
        this.pcapReader = pcapReader;
        this.baseStream = baseStream;
        this.stream = stream;
        this.start = start;
        this.end = end;
        this.reporter = reporter;
        this.pcapReaderIterator = pcapReader.iterator();
    }

    public void close() throws IOException {
        this.stream.close();
    }

    public boolean next(LongWritable key, ObjectWritable value) throws IOException {
        if (!this.pcapReaderIterator.hasNext()) {
            return false;
        }
        key.set(++this.packetCount);
        value.set((Object)this.pcapReaderIterator.next());
        this.reporter.setStatus("Read " + this.getPos() + " of " + this.end + " bytes");
        this.reporter.progress();
        return true;
    }

    public LongWritable createKey() {
        return new LongWritable();
    }

    public ObjectWritable createValue() {
        return new ObjectWritable();
    }

    public long getPos() throws IOException {
        return this.baseStream.getPos();
    }

    public float getProgress() throws IOException {
        if (this.start == this.end) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.getPos() - this.start) / (float)(this.end - this.start));
    }
}

