/*
 * Decompiled with CFR 0.152.
 */
package org.ndx.pcap;

import com.google.common.base.Objects;
import com.google.common.collect.ComparisonChain;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ndx.model.pcap.PacketModel;
import org.ndx.model.pcap.RawFrameHelper;
import org.ndx.pcap.PcapReaderUtil;

public class PcapReader
implements Iterable<PacketModel.RawFrame> {
    public static final Log LOG = LogFactory.getLog(PcapReader.class);
    public static final long MAGIC_NUMBER = -1582119980L;
    public static final int HEADER_SIZE = 24;
    public static final int PCAP_HEADER_SNAPLEN_OFFSET = 16;
    public static final int PCAP_HEADER_LINKTYPE_OFFSET = 20;
    public static final int PACKET_HEADER_SIZE = 16;
    public static final int TIMESTAMP_OFFSET = 0;
    public static final int TIMESTAMP_MICROS_OFFSET = 4;
    public static final int CAP_LEN_OFFSET = 8;
    private final DataInputStream is;
    private Iterator<PacketModel.RawFrame> iterator;
    private LinkType linkType;
    private long snapLen;
    private boolean caughtEOF = false;
    private int frameNumber = 1;
    private boolean reverseHeaderByteOrder = false;
    public byte[] pcapHeader;
    public byte[] pcapRawFrameHeader;
    public byte[] rawFrameData;
    static long UnixBaseTicks = 621355968000000000L;
    static long TicksPerSecond = 10000000L;
    static long TickPerMicroseconds = 10L;

    public PcapReader(DataInputStream is) throws IOException {
        this.is = is;
        this.iterator = new RawFrameIterator();
        this.pcapHeader = new byte[24];
        if (!this.readBytes(this.pcapHeader)) {
            if (this.caughtEOF) {
                LOG.warn("Skipping empty file");
                return;
            }
            throw new IOException("Couldn't read PCAP header");
        }
        if (!this.validateMagicNumber(this.pcapHeader)) {
            String msg = "Not supported type of PCAP file (Couldn't find magic number).";
            LOG.error(msg);
            throw new IOException(msg);
        }
        this.snapLen = PcapReaderUtil.convertInt(this.pcapHeader, 16, this.reverseHeaderByteOrder);
        long linkTypeVal = PcapReaderUtil.convertInt(this.pcapHeader, 20, this.reverseHeaderByteOrder);
        this.linkType = this.getLinkType(linkTypeVal);
        if (this.linkType == null) {
            LOG.error("Unsupported link type: " + linkTypeVal);
            throw new IOException("Unsupported link type: " + linkTypeVal);
        }
    }

    protected PcapReader(LinkType lt) {
        this.is = null;
        this.linkType = lt;
    }

    private PacketModel.RawFrame nextRawFrame() {
        this.pcapRawFrameHeader = new byte[16];
        if (!this.readBytes(this.pcapRawFrameHeader)) {
            return null;
        }
        long ts = PcapReaderUtil.convertInt(this.pcapRawFrameHeader, 0, this.reverseHeaderByteOrder);
        long tsMicroseconds = PcapReaderUtil.convertInt(this.pcapRawFrameHeader, 4, this.reverseHeaderByteOrder);
        long ticks = UnixBaseTicks + ts * TicksPerSecond + tsMicroseconds * TickPerMicroseconds;
        int frameLength = (int)PcapReaderUtil.convertInt(this.pcapRawFrameHeader, 8, this.reverseHeaderByteOrder);
        if (frameLength <= 0) {
            return null;
        }
        this.rawFrameData = new byte[frameLength];
        if (this.readBytes(this.rawFrameData)) {
            return RawFrameHelper.New(this.linkType.ordinal(), this.frameNumber++, frameLength, ticks, this.rawFrameData);
        }
        return null;
    }

    protected boolean validateMagicNumber(byte[] pcapHeader) {
        if (PcapReaderUtil.convertInt(pcapHeader) == -1582119980L) {
            return true;
        }
        if (PcapReaderUtil.convertInt(pcapHeader, true) == -1582119980L) {
            this.reverseHeaderByteOrder = true;
            return true;
        }
        return false;
    }

    protected LinkType getLinkType(long linkTypeVal) {
        switch ((int)linkTypeVal) {
            case 0: {
                return LinkType.NULL;
            }
            case 1: {
                return LinkType.EN10MB;
            }
            case 101: {
                return LinkType.RAW;
            }
            case 108: {
                return LinkType.LOOP;
            }
            case 113: {
                return LinkType.LINUX_SLL;
            }
        }
        return null;
    }

    protected boolean readBytes(byte[] buf) {
        try {
            this.is.readFully(buf);
            return true;
        }
        catch (EOFException e) {
            this.caughtEOF = true;
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public Iterator<PacketModel.RawFrame> iterator() {
        return this.iterator;
    }

    private class DatagramPayload
    implements Comparable<DatagramPayload> {
        private Long offset;
        private byte[] payload;

        public DatagramPayload(Long offset, byte[] payload) {
            this.offset = offset;
            this.payload = payload;
        }

        @Override
        public int compareTo(DatagramPayload o) {
            return ComparisonChain.start().compare(this.offset, o.offset).compare(this.payload.length, o.payload.length).result();
        }

        public boolean linked(DatagramPayload o) {
            if (this.offset + (long)this.payload.length == o.offset) {
                return true;
            }
            return o.offset + (long)o.payload.length == this.offset;
        }

        public String toString() {
            return Objects.toStringHelper(this.getClass()).add("offset", this.offset).add("len", this.payload.length).toString();
        }
    }

    private class SequencePayload
    implements Comparable<SequencePayload> {
        private Long seq;
        private byte[] payload;

        public SequencePayload(Long seq, byte[] payload) {
            this.seq = seq;
            this.payload = payload;
        }

        @Override
        public int compareTo(SequencePayload o) {
            return ComparisonChain.start().compare(this.seq, o.seq).compare(this.payload.length, o.payload.length).result();
        }

        public boolean linked(SequencePayload o) {
            if (this.seq + (long)this.payload.length == o.seq) {
                return true;
            }
            return o.seq + (long)o.payload.length == this.seq;
        }

        public String toString() {
            return Objects.toStringHelper(this.getClass()).add("seq", this.seq).add("len", this.payload.length).toString();
        }
    }

    private class RawFrameIterator
    implements Iterator<PacketModel.RawFrame> {
        private PacketModel.RawFrame next;

        private RawFrameIterator() {
        }

        private void fetchNext() {
            if (this.next == null) {
                this.next = PcapReader.this.nextRawFrame();
            }
        }

        @Override
        public boolean hasNext() {
            this.fetchNext();
            return this.next != null;
        }

        @Override
        public PacketModel.RawFrame next() {
            this.fetchNext();
            try {
                PacketModel.RawFrame rawFrame = this.next;
                return rawFrame;
            }
            finally {
                this.next = null;
            }
        }

        @Override
        public void remove() {
        }
    }

    protected static enum LinkType {
        NULL,
        EN10MB,
        RAW,
        LOOP,
        LINUX_SLL;

    }
}

