/*
 * Decompiled with CFR 0.152.
 */
package org.ndx.model.parsers.applayer;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ndx.model.json.JsonAdapter;
import org.ndx.model.parsers.applayer.AppLayerParser;
import org.ndx.model.parsers.applayer.SslHelper;

public class SslJsonParser
extends AppLayerParser {
    private static final Log LOG = LogFactory.getLog(SslJsonParser.class);
    private static final String SSL_JSON_CONTENT_TYPE = "ssl_record_ssl_record_content_type";
    private static final String SSL_JSON_VERSION = "ssl_record_ssl_record_version";
    private static final String SSL_JSON_RECORD_LENGTH = "ssl_record_ssl_record_length";
    private static final String SSL_JSON_CIPHER_SUITE = "ssl_handshake_ssl_handshake_ciphersuite";
    private static final String SSL_JSON_NOT_BEFORE_UTC = "x509af_notBefore_x509af_utcTime";
    private static final String SSL_JSON_NOT_AFTER_UTC = "x509af_notAfter_x509af_utcTime";

    public SslJsonParser(Integer packetNo) {
        this.packetNumber = packetNo != null ? packetNo : 0;
    }

    public SslJsonParser() {
    }

    public HashMap<String, ArrayList> parse(JsonAdapter payload) {
        HashMap<String, ArrayList> records = new HashMap<String, ArrayList>();
        records.put("ssl_content_types", this.getRecordValues(payload, SSL_JSON_CONTENT_TYPE));
        records.put("ssl_versions", this.getRecordValues(payload, SSL_JSON_VERSION).stream().map(SslHelper::decodeSslVersion).collect(Collectors.toCollection(ArrayList::new)));
        records.put("ssl_record_lengths", this.getRecordValues(payload, SSL_JSON_RECORD_LENGTH));
        records.put("ssl_cipher_suites", this.getRecordValues(payload, SSL_JSON_CIPHER_SUITE).stream().map(SslHelper::cipherSuiteDecToString).collect(Collectors.toCollection(ArrayList::new)));
        Iterator<String> datesBefore = this.getRecordValues(payload, SSL_JSON_NOT_BEFORE_UTC).iterator();
        Iterator<String> datesAfter = this.getRecordValues(payload, SSL_JSON_NOT_AFTER_UTC).iterator();
        ArrayList<Long> intervals = new ArrayList<Long>();
        while (datesBefore.hasNext() && datesAfter.hasNext()) {
            Date after;
            Date before;
            try {
                before = SslHelper.parseDate(datesBefore.next());
                after = SslHelper.parseDate(datesAfter.next());
            }
            catch (ParseException e) {
                continue;
            }
            intervals.add(after.getTime() - before.getTime());
        }
        records.put("ssl_intervals", intervals);
        return records;
    }

    private ArrayList<String> getRecordValues(JsonAdapter payload, String key) {
        ArrayList<String> values = new ArrayList<String>();
        if (payload.isString(key)) {
            values.add(payload.getStringValue(key));
        } else if (payload.isArray(key)) {
            values = payload.getStringArray(key);
        }
        return values;
    }
}

