/******************************************************************************
 *      "Copyright (C) 2006, ApS s.r.o Brno, All Rights Reserved"             *
 ******************************************************************************
 *============================================================================*
 *   Version number    Header/source file for the project   "file name"     *
 *----------------------------------------------------------------------------*
 * VERSION   DATE    TIME  BY   CHANGE/COMMENTS                               *
 *----------------------------------------------------------------------------*
 *============================================================================*/
 
#ifndef OPSCHEDULER_H_
#define OPSCHEDULER_H_

#include <map>
#include <queue>
#include <vector> 
#include <string>
#include "isacctypes.h"

// mode of operations' scheduler
typedef enum OpSchedMode{ OPSCHEDOP, OPSCHEDINSTR};

using namespace std;

// each operation has name and state of pipeline
typedef struct op_s{
	// poiter to function(cmpsim)/token(other tools)
	//isaccpointer op;
	int op;
	// pipeline
	string pipename;
	// stete in pipeline
	int state_num;
	
	op_s() : op(0), state_num(0), pipename("") {}
	op_s(int pOp, int pState_num, char* pPipename) :
		op(pOp),
		state_num(pState_num),
		pipename(pPipename)
		{} 
	
} op_t;   

// operations in each cycle are stored in queue
typedef deque<op_t> oplist_t;

// used to keep context in runtime
// (pipeline, state in pipeline)
typedef map<string, int> pipestate_t;

// class of operation's scheduler
class COpSheduler
{
	// operations sheduler
	OpSchedMode m_mode;				// mode of lexical analysator
	map<int, oplist_t> m_oplists;		// lists of sheduled operation in every cycles
	oplist_t m_oplist;			// list of scheduled oeprations
	oplist_t::iterator m_replmark;	// replacement mark
	map<string,int> m_actsecexplist;	// list of expression attributes in the ACTIVATION Section
	TINSTRSCANFNC m_instrscan;		// function of instruction's scanner
	
	//actual cycle
	int m_cycle;
	// keep info about states in pipelines
	pipestate_t m_pipe_curstate_num;
	// keep last used pipeline
	string m_curpipe;
	
public:	
	// constructor
	COpSheduler(TINSTRSCANFNC instrscan,OpSchedMode mode);
	
	// provided scanner function - scanner works as operations scheduler
	int yylex();

	// set mode of lexical analyzator
	void setmode(OpSchedMode mode);
		
	// put operation behind actual operation
	void putop(int op);	
	void putop(int op, int delay);
	
	// put the list behind actual position in the operation list  
	void putoplist(int oplist[]);
	// put the list at the end in the operation list	
	void appendoplist(int oplist[]);
	
	// is the oplist empty
	bool oplistempty();
	
	// clear the operation list
	void clear();

	// print the olist content
	void printoplist();

	// attribution propagation in the activation section
	void actsecexp_clearlist();
	void actsecexp_set(char *attrname,int value);
	int  actsecexp_get(char *attrname);
	
	// pop replecement mark - determine the replacement place
	void replmark_pop();
	// put the list behind replacment mark in the operation list  
	void replmark_putoplist(int oplist[]);
	
	// increment cycle and plane next operations
	int inc_cycle();
	int get_cycle();
	int get_pipe_curstate_num(char* pipename);
};

// interface for initialisation of the scannerobj and the own scanner
void opschedull_init(TINSTRSCANFNC instrscan);
// clean up the scanner
void opschedull_deinit();
// set mode of lexical analyzator
void opschedull_setmode(OpSchedMode mode);
// put operation behind actual operation
void opschedull_putop(int op);
// put the list behind actual position in the operation list  
void opschedull_putoplist(int oplist[]);
// put the list at the end in the operation list
void opschedull_appendoplist(int oplist[]);

// pop replecement mark - determine the replacement place
void opschedull_replmark_pop();
// put the list behind replacment mark in the operation list  
void opschedull_replmark_putoplist(int oplist[]);

// is the oplist empty
bool opschedull_oplistempty();
// attribution propagation in the activation section
void opschedull_actsecexp_clearlist();
void opschedull_actsecexp_set(char *attrname,int value);
int  opschedull_actsecexp_get(char *attrname);

int  opschedull_inc_cycle();
int  opschedull_get_cycle();
int  opschedull_get_pipe_curstate_num(char* pipename);
// there is provided own scanner for bisson
int yylex();

#endif /*OPSCHEDULER_H_*/
