/******************************************************************************
 *      "Copyright (C) 2006, ApS s.r.o Brno, All Rights Reserved"             *
 ******************************************************************************
 *============================================================================*
 *   Version number    Header/source file for the project   "file name"     *
 *----------------------------------------------------------------------------*
 * VERSION   DATE    TIME  BY   CHANGE/COMMENTS                               *
 *----------------------------------------------------------------------------*
 *============================================================================*/

#include <stdlib.h>
#include <stdio.h>
#include "isiml.h"
#include "dsml.h"
#include "dsmknittingalg.h"
#include "usedattr.h"
#include "cmpsimparser.h"
#include "cpu_res.h"
#include "parserlib.h"
#include "dbgl.h"
#include "dsmscanl.h"
#include "isacexceptions.h"
#include "opschedull.h"
#include "swtiol.h"

int main(int argc, char **argv)
{		
	char *g_ifname=NULL;	// name of binary file
	
	// the Lissom project supports only the fast compiled simulator	
	int g_tsim=TCMPFASTSIM;		// type of the simulator

	// init resources
	reset();
	*_progc = 0;
	
	try
    {
		// get program arguments
		swtiol_argpars_PI1(argc, argv, &g_ifname);

		// initialisation of the statistic library
		rstatl_init(NULL);
		
		// init instruction simulation library
		isiml_init((ISACTMap *) _memmap, _progc, g_ifname, g_tsim);
		
		// init the scanner library
		dsmscanl_init(g_ifname,NULL);

        // initialisation of the operations' scheduler - the argument is function of the disassembler scanner        
        opschedull_init(&dsmscanl_dsmyylex);		
		
		// initialisation of the debugger library
		dbg_init((ISACTMap *) _memmap, _progc, g_tsim);
		
		// write information about binary application
		isiml_obj()->cmpsimsetup_h_binapp_record();
		
		// begin of the behavior section
		isiml_obj()->beginbeh();
		
		// initialisation of the knitting library 	
		dsml_init_knittingalg(YYNT_FIRST, YYNT_LAST);
		
		yyparse();
	
		isiml_obj()->endbeh();
						
		// deinit of knitting library
		dsml_deinit_knittingalg();
		// deinit debug library
		dbg_deinit();
	    // deinitialisation of the operations' scheduler
        opschedull_deinit();
		// deinit the scaner library
		dsmscanl_deinit();
		// deinitialisation of the statistic library
		rstatl_deinit();	
		// deinit simulation library
		isiml_deinit();
    }catch (exception & e)
    {
		// add error prefix before error message alone 
    	string tmp = "Error: ";
    	tmp+=e.what();
        cout << tmp.c_str() << endl;
    }
	
	return 0;
}
