/******************************************************************************
 *      "Copyright (C) 2006, ApS s.r.o Brno, All Rights Reserved"             *
 ******************************************************************************
 *============================================================================*
 *   Version number    Header/source file for the project   "file name"     *
 *----------------------------------------------------------------------------*
 * VERSION   DATE    TIME  BY   CHANGE/COMMENTS                               *
 *----------------------------------------------------------------------------*
 *============================================================================*/

#include <stdlib.h>
#include <sstream>
#include <time.h>
#include "rstatl.h"
#include "cpu_res.h"
#include "dbgl.h"
#include "intersim.h"
#include "isiml.h"
#include "parserlib.h"
#include "usedattr.h"
#include "intersimparser.h"
#include "opschedull.h"
#include "dsml.h"
#include "swtiol.h"

int main(int argc, char **argv)
{
	char *g_ifname=NULL;	// name of binary file
	char *g_ofname=NULL;	// name of output file
	
	try
    {
		// get program arguments
		swtiol_argpars_P2(argc, argv, &g_ifname, &g_ofname);
	
		// initialisation of the statistic library
		rstatl_init(g_ofname);
		
		// init instruction simulation library
		isiml_init((ISACTMap *) _memmap, _progc, g_ifname, TINTRSIM);
	
		// initialisation of operations' scheduler
		opschedull_init(&isiml_isimyylex);
	
		// initialisation of the knitting library 	
		dsml_init_knittingalg(YYNT_FIRST, YYNT_LAST);
	
		// perform reset of cpu's resources	
		reset();
	
		// perform initialisation of the program memory and the program counter		
		isiml_obj()->load_memory();
		isiml_obj()->init_progc();
	
		// initialisation of the debugger
		dbg_init((ISACTMap *) _memmap, _progc, TINTRSIM);
	
		// time measure
		time_t start_time = time(NULL);
	
		//start of the simulation
		yyparse();
		
		time_t end_time = time(NULL);
			
		//watch the result
		fprintf(rstatl_obj()->m_stat_file,"Time elapsed: %d\n", (long)(end_time - start_time));
		fprintf(rstatl_obj()->m_stat_file,"\n------------- REGISTER STATE -------------\n");
		watch_regs();
		fprintf(rstatl_obj()->m_stat_file,"------------------------------------------\n\n");
		fprintf(rstatl_obj()->m_stat_file,"---------------- MEMORY STATE -------------\n");
		watch_mems(50);
		fprintf(rstatl_obj()->m_stat_file,"------------------------------------------\n\n");
		
		// deinit of knitting library
		dsml_deinit_knittingalg();
		
		//deinit of opschedull library
		opschedull_deinit();
		
		// deinit simulation library
		isiml_deinit();

		// deinitialisation of the statistic library
		rstatl_deinit();
    }catch (exception & e)
    {
		// add error prefix before error message alone 
    	string tmp = "Error: ";
    	tmp+=e.what();
        cout << tmp.c_str() << endl;
    }
	
	return EXIT_OK;
}
