/******************************************************************************
 *      "Copyright (C) 2006, ApS s.r.o Brno, All Rights Reserved"             *
 ******************************************************************************
 *============================================================================*
 *   Version number    Header/source file for the project   "file name"     *
 *----------------------------------------------------------------------------*
 * VERSION   DATE    TIME  BY   CHANGE/COMMENTS                               *
 *----------------------------------------------------------------------------*
 *============================================================================*/

#include <stdlib.h>
#include <sstream>
#include <time.h>
#include "isacctypes.h"
#include "parserlib.h"
#include "swtiol.h"

// include all necessary files
#include RSTATL_FILE_H
#include DBGL_FILE_H
#include ISIML_FILE_H
#include SIM_RES_FILE_H
#include CMPSIM_BASE_FILE_H
#include CMPSIM_SETUP_FILE_H
#include CMPSIM_OPSCHEDULL_FILE_H

// the prototype of the starting function
int simmain();

char *g_ifname=NULL;	// name of binary file
char *g_ofname=NULL;	// name of output file
int g_tsim=TSIM;	// type of the simulator, it is in cpu_behavior.cpp


int main(int argc, char **argv)
{
	try
    {
		// get program arguments
		swtiol_argpars_PO1(argc, argv, &g_ofname);
			 
		// set the file name of binary application
		g_ifname = BINAPPNAM;

		// initialisation of the statistic library
		rstatl_init(g_ofname);
		
		// init instruction simulation library
		isiml_init((ISACTMap *) _memmap, _progc, g_ifname, g_tsim);
		
		// initialisation of operations' scheduler
		opschedull_init(&isiml_isimyylex);
		opschedull_setmode(OPSCHEDOP);
		
		//CRC32 check
		if ((unsigned int)isiml_obj()->m_nCrc32 != CRC32)
		{
			printf("Error: CRC of input file is NOT same as CRC of file at the precmp* stage.");
			return EXIT_CRC;
		}
		
		// perform reset of cpu's resources	
		reset();
		
		// perform initialisation of the program memory and the program counter
		isiml_obj()->load_memory();
		isiml_obj()->init_progc();
		
		// initialisation of the debugger
		dbg_init((ISACTMap *) _memmap, _progc, g_tsim);
		
	#ifdef RUN_DBG
		if (!dbg_commands(true))
		{
			return EXIT_OK;
		}
	#endif
		// time measure 
		time_t start_time = time(NULL);
	
		// exectte the simulation
		while (!dbg_obj()->get_halt())
		{
			opschedull_putop((int) simmain);
			while (!(opschedull_oplistempty()) && !dbg_obj()->get_halt())
			{
				TCMPSIMFNC fnc = (TCMPSIMFNC) yylex();
				fnc();
			}
			opschedull_inc_cycle();
		}
		
		time_t end_time = time(NULL);
	
	#ifdef RUN_DBG
		dbg_commands(false);
	#endif
	
		//watch the result
		fprintf(rstatl_obj()->m_stat_file,"Time elapsed: %d\n", (long)(end_time - start_time));
		fprintf(rstatl_obj()->m_stat_file,"\n------------- REGISTER STATE -------------\n");
		watch_regs();
		fprintf(rstatl_obj()->m_stat_file,"------------------------------------------\n\n");
		fprintf(rstatl_obj()->m_stat_file,"---------------- MEMORY STATE -------------\n");
		watch_mems(50);
		fprintf(rstatl_obj()->m_stat_file,"------------------------------------------\n\n");
	
		// deinit simulation library
		isiml_deinit();

		// deinitialisation of the statistic library
		rstatl_deinit();
   	}catch (exception & e)
    {
		// add error prefix before error message alone 
    	string tmp = "Error: ";
    	tmp+=e.what();
        cout << tmp.c_str() << endl;
    }
	
	return EXIT_OK;
}
