# art_projected_gui
Augmented reality user interface.

The main node (to be launched by app.launch) generates 2D scene and takes PoseStamped messages as an input (e.g. from pointing detection node). Projector nodes (projector_node.py) read 2D images generated by the main node and display them in proper way (warped according to projector position and orientation). A debugging window allowing mouse control may be displayed (show_scene parameter).

Dependencies:
```
sudo pip install qimage2ndarray transitions PyQt4
sudo apt-get install graphviz libgraphviz-dev pkg-config pygraphviz
```

Usage (for testing purposes):

```
roslaunch art_db db.launch
rosrun art_projected_gui test_gui.py (publishes two objects)
rosrun art_projected_gui test_brain.py (simulates art_brain)
roslaunch art_projected_gui projector.launch
roslaunch art_projected_gui app.launch
```

After startup, node waits for user to appear. This can be simulated by publishing user_state '1' followed by '2' to /art/user/status topic (of type art_msgs/UserStatus):

```
rostopic pub /art/user/status art_msgs/UserStatus "header:
  seq: 0
  stamp:
    secs: 0
    nsecs: 0
  frame_id: ''
user_id: 0
user_state: 1"
publishing and latching message. Press ctrl-C to terminate
^C
rostopic pub /art/user/status art_msgs/UserStatus "header:
  seq: 0
  stamp:
    secs: 0
    nsecs: 0
  frame_id: ''
user_id: 0
user_state: 2"
publishing and latching message. Press ctrl-C to terminate
^C
```

How to update language files:

```
roscd art_projected_gui
pylupdate4 proj.pro
linguist lang/locale_you_want_to_tweak.ts (save, release)
```
