/**
 *  Convolution.cpp
 *
 *  Created on: 26.10.14.
 *  Author: Jan Brejcha <ibrejcha@fit.vutbr.cz>, <brejchaja@gmail.com>
 *  Copyright (C) 2014  Jan Brejcha
 *
 *  OPEN SOURCE LICENCE VUT V BRNĚ
 *  Verze 1.
 *  Copyright (c) 2010, Vysoké učení technické v Brně, Antonínská 548/1, PSČ 601 90
 *  -------------------------------------------------------------------------------
 */

#include "Convolution.h"
#include <QDebug>

void Convolution::convolve1D(Image &image, float * result, unsigned int kernel_size, float * kernel, int direction)
{
	int kernel_w, kernel_h;
	kernel_w = kernel_size;
	kernel_h = 1;
	if (direction == DIR_VERT)
	{
		kernel_h = kernel_size;
		kernel_w = 1;
	}

	unsigned int index = 0;
	unsigned int index1 = 0;
	int val = 0;
	int res = 0;
	for (int y = 0; y < image.height; ++y)
	{
		for (int x = 0; x < image.width; ++x)
		{
			res = 0;
			index1 = y * image.width + x;
			for (int t = 0; t < kernel_h; ++t)
			{
				for (int s = 0; s < kernel_w; ++s)
				{
					int y_t = y - t;
					int x_s = x - s;
					index = (y_t >= 0 ? y_t : 0) * image.width + (x_s >= 0 ? x_s : 0);
					val = image.data[index];
					res += val * kernel[t * kernel_w + s];
				}
			}
			result[index1] = res;
		}
	}
}

void Convolution::convolve1D(Imagef &image, double * result, unsigned int kernel_size, float * kernel, int direction)
{
	int kernel_w, kernel_h;
	kernel_w = kernel_size;
	kernel_h = 1;
	if (direction == DIR_VERT)
	{
		kernel_h = kernel_size;
		kernel_w = 1;
	}

	unsigned int index = 0;
	//unsigned int index1 = 0;
	double val = 0;
	double res = 0;
	for (int y = 0; y < image.height; ++y)
	{
		for (int x = 0; x < image.width; ++x)
		{
			res = 0;
			int index1 = y * image.width + x;
			for (int t = 0; t < kernel_h; ++t)
			{
				for (int s = 0; s < kernel_w; ++s)
				{
					int y_t = y - t;
					int x_s = x - s;
					index = (y_t >= 0 ? y_t : 0) * image.width + (x_s >= 0 ? x_s : 0);
					val = image.data[index];
					res += val * kernel[t * kernel_w + s];
				}
			}
			result[index1] = res;
			//printf("result: %f, index: %d\n", result[index1], index1);
		}
	}

	/*printf("imageWidth: %d\n", image.width);
	for (int x = 0; x < image.width; ++x)
	{
		printf("%f ", result[x]);
	}
	printf("\n\n");*/
}
