/**
 *  bytearray.cpp
 *
 *  Author: Jan Brejcha <ibrejcha@fit.vutbr.cz>, <brejchaja@gmail.com>
 *  Copyright (C) 2016  Jan Brejcha
 *
 *  OPEN SOURCE LICENCE VUT V BRNĚ
 *  Verze 1.
 *  Copyright (c) 2010, Vysoké učení technické v Brně, Antonínská 548/1, PSČ 601 90
 *  -------------------------------------------------------------------------------
 */

#include "bytearray.h"


ByteArray::ByteArray(const char *data, int size)
: length(size)
{
    arr = new char[size];
    memcpy(arr, data, (sizeof(char) * size));
}

ByteArray::~ByteArray()
{
    delete arr;
}

int ByteArray::size()
{
    return length;
}

const char * ByteArray::getData()
{
    return (const char *)arr;
}
