/**
 *  Author: Martin Čadík <cadik@fit.vutbr.cz>
 *          Lionel Baboud
 *          Jan Brejcha <ibrejcha@fit.vutbr.cz>, <brejchaja@gmail.com>
 *
 *  OPEN SOURCE LICENCE VUT V BRNĚ
 *  Verze 1.
 *  Copyright (c) 2010, Vysoké učení technické v Brně, Antonínská 548/1, PSČ 601 90
 *  -------------------------------------------------------------------------------
 */

#ifndef __PLACE_SET__
#define __PLACE_SET__

#include <QDir>
#include <QString>
#include <QList>
#include <QXmlStreamReader>
#include <QXmlStreamAttributes>
#include <QXmlStreamAttribute>
#include <QDebug>
#include <QDomDocument>
#include <QDomElement>
#include <QFile>
#include <QIODevice>
#include <QTextStream>

#include <cmath>
#include <iostream>
#include <stdexcept>

#include <Eigen/Dense>

#include "XMLUtil.h"

using namespace Eigen;
class Place {
    public:
        Place() {}  // undefined place
        Place(QString shortcut) : shortcut(shortcut) {}
        bool operator==(const Place &p) const { return p.shortcut == shortcut; }
        bool defined() const { return !shortcut.isEmpty(); }
        void setCoordsSpherical(Vector3f pS);   // pS has angles in *radians* and elevation in meters
        //@@ double values
        Vector3f getCoordsSpherical() const;      // returns angles in *radians*

        static void sortDecAltitude(QList<Place> &list);
        //bool operator<(const Place &p) const { return p.elevation < elevation; }    // for sorting by altitude
        
    public:
        QString shortcut;
        QString name;
        double longitude;   // degrees
        double latitude;    // degrees
        double elevation;   // meters

        double heatmap_val; //value to be used for heatmap generation
        double total_edge_len; //total length of all edges at given place
    };

class PlaceSet {
    public:
        PlaceSet(QString fileName);

        static PlaceSet load();
        
        void add(Place p);
        Place get(QString shortcut) const;
        QList<Place> getAll() const;
        void writeAll(QList<Place> places);
        
    private:
        QList<Place> read() const;
        QList<Place> readEfficient() const;
        void write(Place p);
        void write(QList<Place> set);

        double getXMLDoubleAttrib(QDomElement element,
                                  QString attrib_name,
                                  double defaultValue = 0.0) const;

        void saveXML(QDomDocument doc, QString fileName) const;
        
    private:
        QString fileName;
        //@maybe bufferize + merge at write..
        static const QDir root;
    };

#endif

