/**
 *  Author: Martin Čadík <cadik@fit.vutbr.cz>
 *          Lionel Baboud
 *          Jan Brejcha <ibrejcha@fit.vutbr.cz>, <brejchaja@gmail.com>
 *
 *  OPEN SOURCE LICENCE VUT V BRNĚ
 *  Verze 1.
 *  Copyright (c) 2010, Vysoké učení technické v Brně, Antonínská 548/1, PSČ 601 90
 *  -------------------------------------------------------------------------------
 */

#ifndef __CAM_UTIL__
#define __CAM_UTIL__

#include <iostream>

#include <Eigen/Dense>



using namespace Eigen;

class CamUtil {
    public:
        // horizontal FOV = 2pi * hFOV
        static Matrix4f transfoC2N(float hFOV, float vFOV, float zNear, float zFar);

        // horizontal and vertical FOV bound by aspect ratio
        static Matrix4f transfoC2Niso(float hFOV, float aspectRatio, float zNear, float zFar);      // aspectRatio = w / h
        static Matrix4f transfoC2Niso(float hFOV, int w, int h, float zNear, float zFar);
        
        // Canon G9 : sensor = 7.6 x 5.7
        // Canon EOS 500D : sensor = 22.3 x 14.9
        // 35mm film : sensor = 36 x 24
        static float horizFOV(float focalLength, float sensorWidth);
        
        // world coordinates : Z pointing upwards, X to the east, Y to the north
        static void rotationAngles(Matrix4f W2C, float  &yaw, float  &pitch, float  &roll);
        static void rotationAngles(Matrix4d W2C, double &yaw, double &pitch, double &roll);
        static Matrix4f transfoW2C(float  yaw, float  pitch,  float roll);
        static Matrix4d transfoW2C(double yaw, double pitch, double roll);

        static Matrix4d rotationX(double theta);
        static Matrix4d rotationY(double theta);
        static Matrix4d rotationZ(double theta);
        
    private:
        static Matrix4f proj(float ax, float ay, float zNear, float zFar);
    };

#endif

