/**
 *  Author: Jan Brejcha <ibrejcha@fit.vutbr.cz>, <brejchaja@gmail.com>
 *  Copyright (C) 2016  Jan Brejcha
 *
 *  OPEN SOURCE LICENCE VUT V BRNĚ
 *  Verze 1.
 *  Copyright (c) 2010, Vysoké učení technické v Brně, Antonínská 548/1, PSČ 601 90
 *  -------------------------------------------------------------------------------
 */
#ifndef FIELDOFVIEWUTIL_H
#define FIELDOFVIEWUTIL_H

#ifdef __APPLE__
    #include <OpenGL/gl.h>
#else
    #define GL_GLEXT_PROTOTYPES
    #include <GL/gl.h>
    #include <GL/glext.h>
#endif

#include <QImage>
#include <stdexcept>
#include <iostream>
#include <cmath>

using namespace std;

/**
 * @brief The FieldOfViewUtil class
 * Class for manipulating image size based on its field-of-view and panorama
 * width.
 */
class FieldOfViewUtil
{
private:
    /// The image that will be manipulated.
    QImage image;

    /// The field of view of the image in degrees.
    float FOV;

    /// The width of the panorama in pixels.
    int panoWidth;

public:
    /**
     * @brief FieldOfViewUtil
     * @param imagePath
     * Path of the image that shall be adjusted.
     * @param FOV
     * Field-of-view of the image in degrees.
     * @param panoWidth
     * Panorama width in pixels.
     */
    FieldOfViewUtil(QString imagePath, float FOV, int panoWidth);

    /**
     * @brief FieldOfViewUtil
     * @param image
     * Image that shall be adjusted.
     * @param FOV
     * Field-of-view of the image in degrees.
     * @param panoWidth
     * Panorama width in pixels.
     */
    FieldOfViewUtil(QImage image, float FOV, int panoWidth);

    /**
     * @brief fit
     * Resizes the image to fit the field-of-view and the panoWidth.
     */
    QImage fitToFOV();
};

#endif // FIELDOFVIEWUTIL_H
