/**
 *  bytearray.h
 *
 *  Author: Jan Brejcha <ibrejcha@fit.vutbr.cz>, <brejchaja@gmail.com>
 *  Copyright (C) 2016  Jan Brejcha
 *
 *  OPEN SOURCE LICENCE VUT V BRNĚ
 *  Verze 1.
 *  Copyright (c) 2010, Vysoké učení technické v Brně, Antonínská 548/1, PSČ 601 90
 *  -------------------------------------------------------------------------------
 */


#ifndef BYTEARRAY_H
#define BYTEARRAY_H

#include <string.h>

/**
 *	@brief Class to store bytes.
 */
class ByteArray {
private:
    /// Array to store the bytes
    char *arr;

    /// Size of the byte array
    int length;

public:
    /**
     * @param   data the byte data to be stored
     * @size    size of the data array
     */
    ByteArray(const char *data, int size);

    ~ByteArray();

    /**
     * Size of the array.
     * @return size of the array.
     */
    int size();

    /**
     * Get the data pointer.
     * @return pointer to byte data array.
     */
    const char * getData();
};


#endif
