Horizon Localization Tool - HLoc, reimplementation of [Saurer16]
================================================================

![alt text](TACR_logo.png "Logo TA ČR") 

Tento software (Horizon Localization Tool - HLoc) byl vytvořen s finanční podporou TA ČR. This software (Horizon Localization Tool - HLoc) has been developed with financial support from TA ČR.


Welcome! This project reimplements the paper "Image Based Geo-localization in the Alps"
Olivier Saurer and Georges Baatz [Saurer16]. Specifically, it supplements our new paper
"Camera Orientation Estimation in Natural Scenes Using Semantic Cues" and serves as a
baseline for camera orientation estimation. Throughout our paper and this text, we will
denote it as "HLoc" - Horizon-line Localization. In our paper, we thoroughly compare
our method with HLoc and show, that our method which uses semantic segmentation and
edges as complementary features, is much more robust and stable with respect to the
segmentation precision. For details, please see our paper [Brejcha18]
(http://cphoto.fit.vutbr.cz/semantic-orientation/)   

Dependencies
------------
- QT5.4 and above, QT5.8 recommended - https://www.qt.io

It is expected, that the following libraries can be found at the default
path (/usr/), usually installed through linux package manager, or Homebrew
on MacOS.

- libxml2 - http://xmlsoft.org
- qjson - http://qjson.sourceforge.net, also included in this repo at *libs/qjson*
(be sure to use library built with qt5 in case you use library from package)
- boost 1.53 or higher

The following libraries are expected to be compiled manually, and therefore,
are expected to be located at */usr/local/*.

- libpointmatcher - https://github.com/ethz-asl/libpointmatcher

Build
-----
The build was tested on MacOSX 10.13 and GNU/Linux Fedora 26.

1) Install all the dependencies listed above

2) Download this repository into dir `brejcha_hloc`.

3) `cd brejcha_hloc && mkdir build && cd build`

4) `qmake ..`

5) `make -j8` (set number of CPU cores you want to use for make with `-j<num_cores>`)

6) Built tools can be found in build/tools directory.

7) To run orientation estimation experiments, go to `brejcha_hloc/scripts`
and use `hloc_experiment.sh` script.

Horizon-based localization (hloc)
---------------------------------
Tool for horizon-based localization (hloc) is implementation of the [Saurer16]
method (located in *tools/hloc*). Detailed usage info is shown when hloc is run
without any arguments: `./hloc`.

Running orientation estimation experiments
-------------------------------------------
To re-run the experiments we conducted in our paper [Brejcha18], do following:

1) Build the project, see Build instructions above.

2) Download into `<data_path>` & unzip the dataset `cd <data_path> && wget http://cphoto.fit.vutbr.cz/semantic-orientation/data/segments_hloc.zip && unzip segments_hloc.zip`.

3) Ensure, that `build_dir` points into your build directory in `brejcha_hloc/scripts/paths.sh`.

4) Change directory to scripts `cd brejcha_hloc/scripts`

5) Run the experiment like this: `./hloc_experiment.sh <data_path>/<dataset_dir> <query_dir> <result_dir>`, eg. `./hloc_experiment.sh <data_path>/CH1 eth_ch1_sky result_hloc_eth_ch1_sky` to run orientation estimation on CH1 dataset [Saurer16] with the CH1 sky segmentations (provided by the authors of CH1).

License
--------
This software is available under BUT OPEN SOURCE LICENCE version 1. For more details, please refer to the file LICENSE.


References
-----------

[Saurer16] O. Saurer, G. Baatz, K. Köser, L. Ladický, M. Pollefeys: Image Based Geo-localization in the Alps, International Journal of Computer Vision, Volume 116 Issue 3, Pages 213-225, 2016.

[Brejcha18] J. Brejcha, M. Čadík: Camera Orientation Estimation in Natural Scenes Using Semantic Cues, International Conference on 3D Vision (3DV) 2018, Verona, Italy, DOI 10.1109/3DV.2018.00033
