import ply.lex as lex
import ply.yacc as yacc
import global_var


# definicie tokenov
tokens = (
    'STRING', 'NUMBER', 'FIELD', 'GRE', 'LOE', 'EQ', 'NEQ',
)

# literaly
literals = ['+', '-', '*', '/', '>', '<']

# popis tokenov
t_FIELD = r'[a-zA-Z0-9_\.][a-zA-Z0-9_\.]*'
t_STRING = r'\".*\"'
t_GRE = '>='
t_LOE = '<='
t_EQ = '=='
t_NEQ = '!='

t_ignore = " \t"


def t_NUMBER(t):
    r'\d+'
    t.value = int(t.value)
    return t

# chybny token
def t_error(t):
    print("Nepodporovany znak '%s'" % t.value[0])
    global_var.parseerror = True
    t.lexer.skip(1)


# gramatika
def p_inp(p):
    '''inp : exp '>' exp
           | exp '<' exp
           | exp GRE exp
           | exp LOE exp
           | exp NEQ exp
           | exp EQ exp'''


def p_exp(p):
    '''exp : STRING
           | x exp2'''


def p_exp2(p):
    '''exp2 : '+' x exp2
            | '-' x exp2
            | '*' x exp2
            | '/' x exp2
            | '''


def p_x1(p):
    '''x : NUMBER'''


def p_x2(p):
    '''x : FIELD'''
    global_var.fields.append(p[1])  # pridanie fieldu do listu fieldov


# ak chyba v gramatike vypise sa chyba, nastavi sa globalna premenna na urcenie chyby
def p_error(p):
    if p:
        print("Syntakticka chyba pri '%s'" % p.value)
        global_var.parseerror = True
    else:
        print("Syntakticka chyba pri EOF")
        global_var.parseerror = True


# funkcia na zostavenie lexemu a parseru
# vstupom je vyraz, pri lexikalnej alebo syntaktickej chybe vrati False, inak True
def myparse(expression):

    lexer = lex.lex()
    parser = yacc.yacc(debug=False)  # vypnutie debugovacieho suboru

    # kontrola lexemov
    lexer.input(expression)
    while True:
        tok = lexer.token()
        if global_var.parseerror:  # ak chyba
            global_var.parseerror = False  # reset flagu
            return False
        if not tok:
            break

    # syntakticka kontrola
    parser.parse(expression)
    if global_var.parseerror:  # ak chyba
        global_var.parseerror = False  # reset flagu
        return False

    return True
