import os
import yaml
import glob


# funkcia pre konvertovanie PCAP na PDML
# vstupom je cesta k suboru PCAP, vrati nazov vytvoreneho suboru PDML
def getPDML(file):
    tshark = "tshark -r" + file + " -T pdml > tmp.pdml"  # nastavenie spustenia tsharku
    if os.system(tshark) != 0:  # zavola sa tshark, kontrola ci sa skoncilo uspesne
        print("Chyba pri volani TShark na zadany PCAP.")
        exit(1)
    filename = "tmp.pdml"
    return filename  # vratime nazov tmp pdml suboru ktory bude dalej analyzovany


# funkcia pre nacitanie slabin
# vstupom je cesta k priecinku slabin, vrati zoznam slovnikov, kde kazdy prvok reprezentuje jednu slabinu
def getWeaks(path):
    weaks = []  # zoznam pre slabiny
    path = path + "/**/*.yml"
    files = glob.iglob(path, recursive=True)  # subory v priecinku -> rekurzivne nacitanie vsetkych .yml suborov
    for file in files:  # iteracia po suboroch
        try:  #kontrola ci sa da otvorit yaml
            with open(file, 'r') as fd:
                try:  # kontrola ci ma subor spravny format
                    data = yaml.load(fd)  # nacitanie yaml do pythonu(slovniky,zoznamy)
                except Exception as e:
                    print("Chyba pri nacitavani suboru " + file + ".")
                    print(e)
                    continue
        except IOError as e:
            print("Chyba pri nacitavani suboru " + file + ".")
            print(e)
            continue

        for x in data:  # prechod medzi slabinami
            weaks.append(data[x])  # pridanie slabiny do zoznamu slabin
    return weaks  # zoznam vsetkych slabin


# funkcia na kontrolu spravnosti zapisu slabiny a ulozenie hodnot
# vstupom je asociativne pole obsahujuce slabinu, vrati pole obashujuce hodnoty jednotlivych vlastnosti slabin
def checkWeak(weak):
    res = [[], '', '', '']
    for parameter in weak:
        if parameter == 'error':
            res[0] = weak[parameter]
        elif parameter == 'operator':
            res[1] = weak[parameter]
        elif parameter == 'mode':
            res[2] = weak[parameter]
        elif parameter == 'message':
            res[3] = weak[parameter]
        else:  # ak v yaml vola vlastnost ktora neni podporovana
            print("Nepodporvany parameter v YAML.")
            return []

    # ak nebol specifikovany operator tak bude AND
    if len(weak) == 3:
        res[1] = 'AND'

    # ak chyba niektory povinny atribut alebo je tam ale neobsahuje nic
    if res[0] == [] or res[2] == '' or res[3] == '':
        print("Chybny format YAML")
        return []

    return res
