from itertools import product
import xml.etree.cElementTree
import global_var
import re


# funkcia na zistenie hodnot z pdml pri mode single
# vstupom je vyraz, zoznam hodnot a flag indikujuci vyskyt podmienky
def getValuesSingle(expression, values, podmienka):

    tmpvalues = [[] for _ in range(len(global_var.fields))]

    for elem in global_var.xmlfields:
        for idx, el in enumerate(global_var.fields):
            agrcnt = 0
            # kontrola ci field neni funkcia
            if el == 'FUNCTION':
                tmpvalues[idx] = global_var.functionvalues[agrcnt]
                agrcnt += 1
                continue
            if el == 'FOREACH':  # ak tam bola iteracia
                tmpvalues[idx] = global_var.foreachvalues
                continue
            for key in elem:  # inac sa hlada podla atributu
                if key == el:
                    value = elem[key]
                    # escapovanie uvodzoviek
                    value = re.sub('\"', "\\\"", value)

                    tmpvalues[idx].append(value)  # na index premennej pridame jej dalsiu hodnotu

                if key == 'num':
                    global_var.packetnum = elem[key]

    # kontrola ci sa pre kazdy field nasla hodnota, ak nie tak koncime vyhodnotenie
    for el in tmpvalues:
        if len(el) == 0:
            global_var.fields = []
            return False

    # ak vyraz vo funkcii bol zlozeny z viacerych podmienok tak sa vrati kazda dvojica kombinacii
    if podmienka:
        for items in product(*tmpvalues):
            for index, el in enumerate(items):
                values[index].append(items[index])
    else:
        # ak kazdy field ma hodnoty tak pridame to pola hodnot
        for index, el in enumerate(tmpvalues):
            values[index].extend(tmpvalues[index])

    # nahradenie premenych s {} kvoli funkcie format
    for i in range(len(global_var.fields)):
        tmpexp = re.sub('\\b' + global_var.fields[i] + '\\b', '{}', expression[0])
        expression.clear()
        expression.append(tmpexp)  # .replace(expression[0],tmpexp)

    global_var.fields = []  # vynulovanie listu fieldov po kontorle danej slabiny

    return True


# funkcia na zistenie hodnot z pdml pri mode all
# vstupom je vyraz, zoznam hodnot, pri uspresnom vyhodnoteni vrati True, inak False
def getValuesAll(expression, values):

    # iteracia nad prvkami PDML
    for event, elem in xml.etree.cElementTree.iterparse('tmp.pdml', events=('start', 'end')):
        if event == 'start':
            if elem.tag == 'field':
                for idx, el in enumerate(global_var.fields):  # iteracia cez atributy z vyrazu
                    agrcnt = 0
                    if el == 'FUNCTION':  # ak tam bola funkcia pouzije sa jej vysledok
                        values[idx] = global_var.functionvalues[agrcnt]
                        agrcnt += 1
                        continue
                    if el == 'FOREACH':  # ak tam bola funkcia pouzije sa jej vysledok
                        values[idx] = global_var.foreachvalues
                        continue
                    if elem.get('name') == el:
                        value = elem.get('show')

                        value = re.sub('\"', "\\\"", value)

                        values[idx].append(value)  # na index premennej pridame jej dalsiu hodnotu

        elem.clear()

    # kontrola ci sa pre kazdy field nasla hodnota, ak nie tak koncime byhodnotenie
    for el in values:
        if len(el) == 0:
            global_var.fields = []
            return False

    # nahradenie premenych s {} kvoli funkcie format
    for i in range(len(global_var.fields)):
        tmpexp = re.sub('\\b' + global_var.fields[i] + '\\b', '{}', expression[0])
        expression.clear()
        expression.append(tmpexp)

    global_var.fields = []  # vynulovanie listu fieldov po kontorle danej slabiny

    return True


# funkcia, ktora ulozi paket -> ulozi hodnoty potrebnych atributov
# vstupom ej iterator do suboru PDML, do globalnej premennej ulozi hodnoty atributov name a show
def getPacket(myiterator):
    # iteracia nad prvkami PDML(xml) - nemusi sa nacitat cely subor naraz
    for event, elem in myiterator:
        # ak sa jedna o zaciatok prvku pdml
        if event == 'start':
            if elem.tag == 'field':  # kontrola ci sa jedna o field
                # kontrola ci nazov a hodnota nie su prazdne
                if elem.get('name') is not None and elem.get('show') is not None:
                    # ulozi sa nazov fieldu a hodnota pre neskorsiu kontrolu
                    global_var.xmlfields.append({elem.get('name'): elem.get('show')})
        # ak sa jedna o koniec prvku pdml
        if event == 'end':
            if elem.tag == 'packet':  # ak koniec paketu tak nastavime flag
                return
        # vymazanie aktualneho prvku
        elem.clear()
