import ipaddress


# pomocne funkcie, pracuju nad zoznamami a vysleodk je zoznam

# vstupom je zoznam hodnot, vrati pocet hodnot
def COUNT(values):
    return [len(values)]


# vstupom je zoznam hodnot, vrati maximalnu hodnotu
def MAX(values):
    return [max(values)]


# vstupom je zoznam hodnot, vrati minimalnu hodnotu
def MIN(values):
    return [min(values)]


# vstupom je zoznam hodnot, vrati zoznam podretazcov pre kazdy prvok v rozsahu start-end
def SUBSTR(values, start, end):
    res = []
    for value in values:
        res.append(value[start:end + 1])
    return res


# vstupom je zoznam hodnot, vrati zoznam uplnych ipv6 adres pre kazdu hodnotu
def FQIPV6(values):
    res = []
    for i, value in enumerate(values):
        address = ipaddress.ip_address(value)
        res.append(address.exploded)
    return res


# vstupom je zoznam hodnot, vrati priemer hodnot
def AVG(values):
    return [sum(values) / len(values)]


# vstupom je zoznam hodnot, vrati zoznam unikatnych hodnot
def UNIQUE(values):
    tmpset = set()
    res = []
    for val in values:
        if val not in tmpset:
            res.append(val)
            tmpset.add(val)
    return res
