from myparser import *
from evaluation import *
from getvalues import *
from getvalues import *
from functions import *
import xml.etree.cElementTree
import global_var


# pocitanie zatvoriek a pridavanie stringu do vysledku, tj. ziskanie pomocnej funkcie(aj vnorenych)
# vstupom je index zaciatku danej funkcie a vyraz, vrati celu funkciu
def getString(index, string):
    res = ''  # vysledok

    while string[index] != '(':
        res += string[index]
        index += 1

    # ked sme v tejto funkcii existuje aspon 1 otvaracia zatvorka,
    # ktoru po najdeni automaticky pridame a pocitadlo bude 1
    counter = 1  # pocitadlo zatvoriek
    res += '('
    index += 1  # preskocime (, vieme ze tu je

    # kym sa nenasla kazda kombinacia () tak sa hlada )
    while counter:
        res += string[index]  # pridavanie do vysledku
        if string[index] == '(':
            counter += 1  # ak otvaracia zatvorka, zvysime pocitadlo
        elif string[index] == ')':
            counter -= 1  # ak zatvaracia zatvorka, znizime pocitadlo
        index += 1
        if index == len(string):  # ak uz koniec stringu
            break
    return res


# ziskanie zoznamu vyskytu pomocnych funkcii vo vyraze
# vstupom je vyraz, vrati zoznam funkcii
def getFunction(exp):
    res = []
    for match in re.finditer(r'(?<![(A-Za-z0-9])[A-Za-z0-9]+\(', exp):  # pre kazdu pom. fn sa nacita cela funkcia
        fn = getString(match.start(), exp)
        res.append(fn)
    return res


# funkcia na kontrolu a vyhodnoteine pomocnych funkcii - najde, pozrie vyraz, vyhodnoti, nahradi
# vstupom je vyraz a mod, vrati vyraz hanradeny slovami FUNCTION, ulozi vysledky funkcii do globalneho zoznamu vysledkov funkcii
# ak sa pre niektory atribut paketu nenajde hodnota vrati False
def checkFunctions(expression, mode):

    # kontrola vyskytu funkcii, vrati sa ich zoznam
    functions = getFunction(expression)

    global_var.functionvalues = []

    vyrazy = []

    # cyklus nad zoznamom zistenych najvonkajsich funkcii vo vyraze
    for idx, fn in enumerate(functions):
        fnlist = []  # list pre ukladanie funkcii a parametrov(kvoli vnorenym funkciam)
        fullfn = fn  # ulozenie celej funkcie
        values = [[]]

        # kontrola vnorenych funkcii
        while True:
            tmp = []
            r = re.match(r'([A-Za-z0-9]+)\(([A-Za-z0-9._><=! \"():]+)(([,][0-9]+)*)\)', fn)
            # ak sa uz nenasla vnorena funkcia, tak konci cyklus
            if not r:
                break
            # ak sa nasla vnorena
            tmp.append(r.group(1))  # pridame nazov funkcie
            tmp.append(r.group(3))  # pridame pripadne argumenty
            fnlist.append(tmp)  # pridame list unkcie a argumentov do listu funkcii(vnorenych)
            fn = r.group(2)  # ostava vnutorna cast, znovu kontrola
        field = fn

        # vo field je obsah, kontrolovat ci je vyraz alebo iba field
        r = re.search(r'[><=!]+', field)  # ak je tam operator na porovnanie, tak je tam podmienka

        if r:
            # split podla ANDu
            vyrazy = field.split(" and ")
            if vyrazy[0] == field:  # ak nebol and tak skusime or
                vyrazy = field.split(" or ")
            # prechod vyrazov medzi logickymi operatormi
            for el in vyrazy:
                if not myparse(el):
                    return False  # ak niektory vyraz nespravny tak sa nevyhodnocuje funkcia
        else:
            global_var.fields.append(field)

        # getvalues pre field
        tmpfields = global_var.fields

        if mode == 'single':
            # ak sa nenasli hodnoty koncime vyhodnotenie
            values = [[] for _ in range(len(global_var.fields))]
            if not getValuesSingle([field], values, True):
                return False
            global_var.fields = tmpfields
        else:  # if mode all
            # ak sa nenasli hodnoty koncime vyhodnotenie
            # ak bol AND alebo OR - hladame fieldy v paketoch
            if len(vyrazy) > 1:
                values = [[] for _ in range(len(global_var.fields))]

                # ziskanie hodnot z paketov
                myiterator = xml.etree.cElementTree.iterparse('tmp.pdml', events=('start', 'end'))
                for event, elem in myiterator:
                    # ak sa jedna o zaciatok prvku pdml
                    if event == 'start':
                        if elem.tag == 'packet':  # kontrola zaciatku paketu
                            getPacket(myiterator)  # ziskanie obsahu paketu
                            if not getValuesSingle([field], values, True):  # ziskanie hodnot z paketu
                                # vyprazdneni zoznamov
                                global_var.xmlfields = []  # vynulovanie zoznamu na ukladanie paketu
                                global_var.fields = tmpfields
                                continue
                            # vyprazdnenie zoznamov
                            global_var.xmlfields = []  # vynulovanie zoznamu na ukladanie paketu
                            global_var.fields = tmpfields
                    # vymazanie aktualneho prvku
                    elem.clear()

            else:  # ak jednoduchy vyraz(1 podmienka)
                if not getValuesAll([field], values):
                    return False

            global_var.fields = tmpfields

        # ak vyraz tak evalFunction
        if r:
            values = evalFunction(values, field)
        else:
            values = values[0]  # 1 field teda iba jeden list vo values ->ten prvy

        # volanie jednotlivych vnorenych funkcii(opacne ako boli ulozene tj. z vnutra smerom von sa volaju)
        for func in reversed(fnlist):
            toeval = func[0] + '(' + 'values' + func[1] + ')'  # vytvorime string funkcie na zavolanie
            values = eval(toeval)  # zavolanie funkcie

        # v originalnom vyraze sa funkcia nahradi slovom FUNCTION a hodnoty sa ulozia do pola hodnot funkcii
        expression = re.sub(re.escape(fullfn), 'FUNCTION', expression)  # nahradime so slovom FUNCTION agr. funkciu
        global_var.functionvalues.append(values)  # pridame list hodnot do hodnot agr. funkcii

    global_var.fields = []
    # vrati sa modifikovany vyraz
    return expression


# funkcia na vyhodnotenie foreachu vo vyraze
# format: foreach [premenna] [pomocna funkcia] [pomocna funkcia] [operator] [hodnota]
# vstupom je vyraz a mod, vrati vyraz hanradeny slovami FOREACH, ulozi vysledky funkcii do globalneho zoznamu vysledkov iteracie
# ak sa pre niektory atribut paketu nenajde hodnota vrati False
def checkForeach(expression, mode):
    global_var.foreachvalues = []

    # regularny vyraz na zistenie potrebnych hodnot z vyrazu
    r = re.match(r'^foreach ([a-z]) in ([A-Z]+\([a-zA-Z0-9_.]+\)) ([A-Z]+\(.*\)) [=!><]+ (.*)$', expression)

    if not r:  # ak nenasiel sa foreach
        return expression

    var = r.group(1)  # premenna vo foreach - neskor nahradit
    forlist = r.group(2)  # funkcia ktora vrati zoznam nad ktorym sa bude iterovat
    func = r.group(3)  # funkcia, kde bude premenna nahradena a bude postupne vyhodnotena

    # kontrola, ci sa nasli hodnoty pre parameter funkcie
    if checkFunctions(forlist, mode):
        forlist = global_var.functionvalues[0]
    else:
        return False

    # cyklus for nad hodnotami zoznamu(tj. vysledok prvej funkcie)
    for y in forlist:
        newfunction = re.sub(re.escape(var), '"' + y + '"', func)

        # ak sa nenajdu hodnoty tak sa vrati false
        if not checkFunctions(newfunction, mode):
            return False

        # pridanie vysledkov funkcie do globalneho zoznamu hodnot foreach
        global_var.foreachvalues.extend(global_var.functionvalues[0])

    # nahradime celu lavu stranu foreach so slovom FOREACH
    r = re.match(r'^foreach ([a-z]) in ([A-Z]+\([a-zA-Z0-9_.]+\)) ([A-Z]+\(.*\) [=!><]+ .*)$', expression)
    exp = r.group(3)
    expression = re.sub(r'[A-Z]+\(.*\)', 'FOREACH', exp)
    return expression
