#!/usr/bin/env python3.6
# coding=utf-8

# Bakalárska práca
# Detekce slabin v počítačových sítích
# Autor: Peter Šuhaj
# Vedúci: Ing. Martin Holkovič
# Ústav: UIFS
# Copyrigth 2018, Peter Šuhaj
# FIT VUT 2018

# potrebne importy
import sys
import time
import xml.etree.cElementTree
from loadfiles import *
from modes import *
from getvalues import *
import global_var


# kontrola argumentov programu
# vstupom su argumenty programu, pri chybnych argumentoch vrati False, inak True
def checkArgs(argv):
    # kontrola poctu argumentov
    if len(argv) != 3:
        print("Chybne argumenty!")
        return False

    # kontrola cesty PCAP
    if not os.path.isfile(argv[1]):
        print("Zadany subor neexistuje!")
        return False

    # kontrola spravnosti priecinku so slabinami
    if not os.path.isdir(argv[2]):
        print("Zadany priecinok neexistuje!")
        return False

    return True


# hlavna cast detektoru, vstupom su argumenty programu
def main(args):
    # start_time = time.time()  # ulozenie casu spustenia
    
    # spracovanie argumentov
    if not checkArgs(args):
        exit(1)  # ak sa vyskytla chyba konci program

    getPDML(args[1])  # ziskanie pdml
    weaks = getWeaks(args[2])  # ziskanie slabin

    # vypis doby spracovania vstupnych suborov
    '''
    print("Cas spracovania suborov: ", end='')
    files_time = time.time()
    print(round(files_time - start_time, 2))
    '''

    # iteracia nad slabinamy - hlavna cast detektoru
    for weak in weaks:

        # kontrola zapisu slabiny
        ymlvalues = checkWeak(weak)

        # ak chyba v slabine tak pokracuje sa na dalsiu
        if not ymlvalues:
            continue

        # ak OK ulozia sa hodnoty
        expressions = ymlvalues[0]
        operator = ymlvalues[1]
        mode = ymlvalues[2]
        message = ymlvalues[3]

        # na zaciatku vsetky vyrazy budu false
        for i in range(len(expressions)):
            global_var.flags.append(False)

        # kontrola modu
        if mode == 'single':
            myiterator = xml.etree.cElementTree.iterparse('tmp.pdml', events=('start', 'end'))
            for event, elem in myiterator:
                # ak sa jedna o zaciatok prvku xml
                if event == 'start':
                    if elem.tag == 'packet':  # kontrola zaciatku paketu
                        getPacket(myiterator)  # ziskanie obsahu paketu
                        if modeSingle(expressions):  # ziskanie hodnot atributov paketu a vyhodnotenie jednotlivych vyrazov
                            # vyhodnotenie vysledku vyrazov
                            if result(operator):  # aplikovanie operatoru na vysledky vyrazov
                                print(message + " Paket cislo: " + global_var.packetnum)
                        global_var.xmlfields = []  # vynulovanie zoznamu na ukladanie paketu
                # vymazanie aktualneho prvku
                elem.clear()

        elif mode == 'all':
            # ak v kazdom vyraze sa nasli hodnoty pre atributy paketu tak sa vyhodnoti slabina
            if modeAll(expressions):
                if result(operator):  # aplikovanie operatoru na vysledky vyrazov
                    print(message)

        # vymazanie obsahu zoznamov
        global_var.xmlfields = []
        global_var.fields = []
        global_var.flags = []

    os.remove("tmp.pdml")  # odstranie pdml
    # os.remove("parsetab.py")  # odstranie tmp suboru -> mozno odkomentovat pri beznom fungovani, pri testoch zakomentovat

    # vypis doby kontroly
    '''
    print("Cas kontroly: ", end='')
    controll_time = time.time() - files_time
    print(round(controll_time, 2))
    '''

    exit(0)  # uspesny koniec


if __name__ == "__main__":
    main(sys.argv)
