# Projekt:  Bakalářská práce
# Název:    Extrakce tunelovaných dat do samostatných toků
# Autor:    Roman Nahálka, xnahal01@stud.fit.vutbr.cz
# Datum:    22.03.2018
# Soubor:   tunnels.py
# Popis:    Trida pro tunelovací protokoly.

from enum import Enum


class IpProtocols(Enum):
    GRE = 47
    IP4 = 4
    IP6 = 41
    L2TP = 115

    @classmethod
    def hasValue(cls, value):
        for item in cls:
            if value == item.value:
                return True

        return False


class Tunnels:
    def __init__(self):
        self.__proto = 0

    def isIpTunnell(self, header):
        tunnel = False

        for field in header:
            if field.get('name') == 'ip.proto' or field.get('name') == 'ipv6.nxt':
                self.__proto = int(field.get('show'))
                break

        if IpProtocols.hasValue(self.__proto):
            self.__proto = IpProtocols(self.__proto)
            tunnel = True

        return tunnel

    def tunnelHeaders(self, header, pdml, removed):
        if self.__proto == IpProtocols.GRE:
            return self.__gre(header, pdml, removed)

        elif self.__proto == IpProtocols.L2TP:
            return self.__L2TP(header, removed)

        elif (self.__proto == IpProtocols.IP4) or (self.__proto == IpProtocols.IP6):
            return self.__ipip(header)

    def __gre(self, header, packet, removed):
        # GRE + Muze byt GRETAP ci PPTP
        proto = packet[header + 1]
        greType = proto.find('.//field[@name="gre.proto"]').get('value')

        if greType == '6558':
            return self.__gretap(header, removed)

        return [header, header + 1]


    def __ipip(self, header):
        # IPIP = 4in4, 4in6, 6in4, 6in6
        # Urcena k odstraneni je pouze prvni IP hlavicka
        return [header]

    def __gretap(self, header, removed):
        eth = header - 1

        if eth in removed:
            eth = self.__ethHeader(eth, removed)

        return [eth, header, header + 1]

    def __L2TP(self, header, removed):
        eth = header - 1

        if eth in removed:
            eth = self.__ethHeader(eth, removed)

        return [eth, header, header + 1, header + 2]

    def __ethHeader(self, header, removed):
        while header in removed:
            header -= 1

        return header
