# Projekt:  Bakalářská práce
# Název:    Extrakce tunelovaných dat do samostatných toků
# Autor:    Roman Nahálka, xnahal01@stud.fit.vutbr.cz
# Datum:    06.03.2018
# Soubor:   parser.py
# Popis:    Třída reprezentující parser souborů ve formátu PDML.

import xml.etree.ElementTree as ET
import fileCreator
import os


class Parser:
    def __init__(self):
        self.__flows = []
        self.__packets = []
        self.__files = []

    def parseMain(self, name):
        # Nalezneme koren PDML souboru
        tree = ET.parse(name)
        pdml = tree.getroot()

        # Kazdemu paketu priradime sitovi tok
        for packet in pdml:
            self.__flowAssign(packet)

        # Kazdy tok rozdelime do samostatneho PDML souboru
        self.__newPdmls(name)

    def __flowAssign(self, packet):
        destIp = ''
        sourceIp = ''
        protoIp = 0
        ipNumber = 0
        destPort = 0
        sourcePort = 0
        five = []

        # Prohledame kazdou hlavicku v paketu s cilem ziskat potrebne iformace o toku
        for proto in packet:
            protoName = proto.get('name')

            if protoName == 'ip':
                ipNumber += 1

                # V souboru se nachazi vice IP hlavicek, ulozime prechozi
                if (ipNumber > 1):
                    new = [ipNumber - 1, destIp, sourceIp, protoIp, destPort, sourcePort]
                    five.append(new)
                    destIp = ''
                    sourceIp = ''
                    protoIp = 0
                    destPort = 0
                    sourcePort = 0

                # Nalezli jsme IP hlavicku, ulozime potrebne informace
                for field in proto:
                    fieldName = field.get('name')

                    if fieldName == 'ip.src':
                        sourceIp = field.get('show')

                    if fieldName == 'ip.dst':
                        destIp = field.get('show')

                    if fieldName == 'ip.proto':
                        protoIp = field.get('show')

            # Nalezli jsme TCP hlavikcu, ulozime potrebne informace
            if protoName == 'tcp':
                for field in proto:
                    fieldName = field.get('name')

                    if fieldName == 'tcp.srcport':
                        sourcePort = field.get('show')

                    if fieldName == 'tcp.dstport':
                        destPort = field.get('show')

            # Nalezli jsme UDP hlavicku, ulozime potrebne iformace
            if protoName == 'udp':
                for field in proto:
                    fieldName = field.get('name')

                    if fieldName == 'udp.srcport':
                        sourcePort = field.get('show')

                    if fieldName == 'udp.dstport':
                        destPort = field.get('show')

        # Ulozime posledni potrebne iformace
        new = [ipNumber, destIp, sourceIp, protoIp, destPort, sourcePort]
        five.append(new)

        # Prirazeni paketu k danemu sitovemu toku
        if five in self.__flows:
            # Dany tok je jiz ulozeny, priradime k nemu dalsi paket
            index = self.__flows.index(five)
            self.__packets[index].append(packet)

        else:
            # Overime jeste, zda neni dany tok ulozeny, jen ma opacne zdrojove a cilove adresy a porty
            for info in five:
                info[1], info[2] = info[2], info[1]
                info[4], info[5] = info[5], info[4]

            if five in self.__flows:
                # Takovy tok existuje, priradime k nemu paket
                index = self.__flows.index(five)
                self.__packets[index].append(packet)

            else:
                # Tento tok jeste v souboru nebyl, ulozime ho a priradime k nemu prvni paket
                self.__flows.append(five)
                new = [packet]
                self.__packets.append(new)

    def __newPdmls(self, name):
        number = 0

        # Projedeme vsechny sitove toky
        for flows in self.__packets:
            number += 1
            fileName = os.path.basename(os.path.splitext(name)[0])
            fileName += "_flow" + str(number) + '.pdml'

            # Vytvoreni noveho souboru s jednim sitovym tokem
            fileCreator.newPdml(fileName, flows)

            self.__files.append(fileName)

    @property
    def getFiles(self):
        return self.__files
