# Projekt:  Bakalářská práce
# Název:    Extrakce tunelovaných dat do samostatných toků
# Autor:    Roman Nahálka, xnahal01@stud.fit.vutbr.cz
# Datum:    02.04.2018
# Soubor:   error.py
# Popis:    Třída, která reprezentuje chybové hlášení.

import sys
from enum import Enum


class Errors(Enum):
    BAD_ARGUMENT = 'Zadán špatný argument!'
    MULTIPLE_ARGUMENTS = 'Některý argument byl zadán vícekrát'
    NO_FILE = 'Zadaný soubor neexistuje!'
    BAD_FILE = 'Zadaný soubor je ve špatném formátu'
    CANT_CONVERT = 'Zadaný soubor nelze konvertovat'
    UNKNOWN_PROTOCOL = 'V souboru se vyskytuje neznámý protokol'


def printErr(err, code):
    # Vytiskne na standartni chybovi vystup danou chybou hlasku
    print(err.value, file=sys.stderr)

    # Pokud nastala chyba, kdy nemuze skript dale pokracovat, ukonci skript
    if code != 0:
        sys.exit(code)
