/*
 * main.cpp
 *
 *  Created on: 15. 12. 2016
 *      Author: nosko
 */

#include <iostream>
#include <stdint.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <cstdlib>
#include <fstream>
#include <vector>
#include <algorithm>
#include <cmath>

#include "hdrlib.hpp"

#include "python_spec.hpp"

#include "hdrlib_tonemap_intf.hpp"
#include "hdrlib_tonemap_durand.hpp"

int main (int argc, char *argv[])
{
/*	if (argc != 2)
	{
		std::cout << "Wrong parameter count\n";
		return -1;
	}
*/
	//std::string sOut = argv[7];
	int images = strtol(argv[1], NULL, 10);
	
	if (argc < images*2)
	{
		std::cout << "Wrong parameter count\n";
		return -1;
	}
	
	cv::Mat ldrLoaded[images];
	uint32_t expTime[images];
	for(int i = 0; i < images; i++){
		ldrLoaded[i] = (hdr::imageRead(argv[2+i]));
		expTime[i] = strtol(argv[(images+2)+i], NULL, 10);
	}
	
	std::string outPath = argv[images*2+2];
//	cv::Mat ldr0Loaded(hdr::imageRead(s0));
//	cv::Mat ldr1Loaded(hdr::imageRead(s1));
//	cv::Mat ldr2Loaded(hdr::imageRead(s2));
	hdr::LdrMat ldr[images];
	hdr::LdrMat ldrLab[images];
//	hdr::LdrMat ldr1;
//	hdr::LdrMat ldr2;

	/*if (ldr0Loaded.empty() || ldr0Loaded.empty() || ldr0Loaded.empty())
	{
		std::cout << "Chyba nacitania obrazku!!!" << std::endl;
	}*/


//	cv::Mat inverseVector = hdr::arrayToCvMat(pixelMapping, 256);

//	if (ldr0Loaded.type() == CV_8UC1){
//		std::cout << (uint32_t)ldr0Loaded.at<uint8_t>(1040, 1225) << std::endl;
//		hdr::linearize(ldr0Loaded, inverseVector);
//		std::cout << (uint32_t)ldr0Loaded.at<uint8_t>(1040, 1225) << std::endl;
//	}
	//cv::namedWindow( "Original image", cv::WINDOW_NORMAL );
	for(int i = 0; i < images; i++){
		float maximum = 0.0;
		float minimum = 100000.0;
		cv::Mat tmp, tmpLab;
		if(ldrLoaded[i].type() == CV_16UC3){	//TIFF soubory
			
			ldrLoaded[i].convertTo(tmp, CV_32FC3, 0.00390625);
			//cvtColor(ldrLoaded[i], tmpLab, cv::COLOR_BGR2Lab);	//TODO otestovat!!!
			
		}else{
			if (ldrLoaded[i].type() == CV_8UC1)
			{
				hdr::debayer(ldrLoaded[i]).convertTo(tmp, CV_32FC3);
			}else{
				ldrLoaded[i].convertTo(tmp, CV_32FC3);
			}
			
			//cvtColor(ldrLoaded[i], tmpLab, cv::COLOR_BGR2Lab);
			//tmpLab.convertTo(tmpLab, CV_32FC3);	//, 0.00390625
			//tmpLab.convertTo(tmpLab, CV_32FC3, 256.0);	//, 0.00390625
			/*tmpLab.convertTo(tmpLab, CV_8UC3);
			cvtColor(tmpLab, tmpLab, cv::COLOR_Lab2BGR);
			
			cv::namedWindow( "Original image", cv::WINDOW_NORMAL );
			cv::imshow( "Original image", tmpLab);
    		int key = cv::waitKey(0); 	*/
    		
		}
		/*
		cv::Mat magnitudes = cv::Mat(ldrLoaded[i].rows, ldrLoaded[i].cols, CV_8UC1);
		
		for (uint32_t y = 0; y < tmpLab.rows; y++)
		{
			for (uint32_t x = 0; x < tmpLab.cols; x++)
			{
				float A = tmpLab.at<cv::Vec3f>(y, x)[1];
				float B = tmpLab.at<cv::Vec3f>(y, x)[2];
				float mag = sqrt((float)(A*A+B*B));
				maximum = MAX(maximum, mag);
				minimum = MIN(minimum, mag);
				
				//if(mag == 0)
				//	std::cout<< "x: " << x << ", y: " << y << std::endl;
				magnitudes.at<unsigned char>(y, x) = MIN((unsigned char)mag, 255);
				//maximum = MAX(maximum, ldrLoaded[i].at<uint8_t>(y, x));
				//minimum = MIN(minimum, ldrLoaded[i].at<uint8_t>(y, x));
			}
		}
		cv::namedWindow( "Magnitudes", cv::WINDOW_NORMAL );
		cv::imshow( "Magnitudes", magnitudes);
		int key = cv::waitKey(0);
		ldrLab[i] = hdr::LdrMat(tmpLab, expTime[i]);*/
		ldr[i] = hdr::LdrMat(tmp, expTime[i]);
		std::cout <<"img " << i << " " << ldr[i].size() << ", expTime: " << expTime[i] << "; maximum mag: "<< maximum << "; minimum mag: " << minimum << std::endl;
	}


	int referenceIndex = images/2;
	std::vector<float> ghostExposureRatios;
	for(int i = 0; i < images; i++){
		if(i <= referenceIndex){
			ghostExposureRatios.push_back(ldr[referenceIndex].getExposureTime()/ldr[i].getExposureTime());
		}else{
			ghostExposureRatios.push_back(ldr[i].getExposureTime()/ldr[referenceIndex].getExposureTime());
		}
	}
		
	std::vector<float> exposureRatios;
	for(int i = 0; i < images; i++){
		exposureRatios.push_back(ldr[images-1].getExposureTime() / ldr[i].getExposureTime());
	}

	std::cout << "ghostExposureRatios" << std::endl;
	for (std::vector<float>::iterator it = ghostExposureRatios.begin(); it != ghostExposureRatios.end(); it++)
	{
		std::cout << *it << std::endl;
	}


	std::cout << "exposureRatios" << std::endl;
	for (std::vector<float>::iterator it = exposureRatios.begin(); it != exposureRatios.end(); it++)
	{
	    std::cout << (*it) << std::endl;
	}


	hdr::CertaintyMergeUni certaintyMerge = hdr::CertaintyMergeUni();

	// 1. vytvorenie sekvencie ldr snimkov
	std::vector<hdr::LdrMat> ldrSeq;
	std::vector<hdr::LdrMat> ldrSeqLab;
	for(int i = 0; i < images; i++){
		ldrSeq.push_back(ldr[i]);
		ldrSeqLab.push_back(ldrLab[i]);
	}
	
	// 2. inicializacia parametrov
	certaintyMerge.setSequence(ldrSeq);//, ldrSeqLab);
	certaintyMerge.setParameters(60.0f, referenceIndex, ghostExposureRatios, exposureRatios);

	// 3. aplikovanie skladania
	certaintyMerge.apply();
	std::cout << "applied" << std::endl;
	certaintyMerge.writeImages(outPath);
	if(argc == images*2+4){
		std::cout<< "printing .hdr output to: " << argv[images*2+3] << std::endl;
		cv::imwrite(argv[images*2+3], certaintyMerge.getImage());
	}
	
	std::cout << "saved" << std::endl;
	hdr::tmo::TonemapDurand durand = hdr::tmo::TonemapDurand(certaintyMerge.getImage());
	durand.prepare(15, 2, 2.0);
	durand.apply();
	durand.writeImages(outPath);
	
	return 0;
}

