/*
 * hdrlib_histogram_merge.hpp
 *
 *  Created on: 3. 11. 2017
 *      Author: nosko
 */

#ifndef HDRLIB_MULTIHISTOGRAM_MERGE_HPP_
#define HDRLIB_MULTIHISTOGRAM_MERGE_HPP_

#include <vector>
#include "hdrlib_base.hpp"
#include "hdrlib_composer_intf.hpp"

#include "opencv2/imgproc/imgproc.hpp"
#include "opencv2/imgproc/imgproc_c.h"
#define cvQueryHistValue_1D( hist, idx0 ) \
cvGetReal1D( (hist)->bins, (idx0) )

namespace hdr
{

class MultiHistogramMerge : public ComposerInterface
{
private:
	std::vector<LdrMat> sequence;
	std::vector<float> exposureRatios;
	std::vector<float> ghostExposureRatios;
	cv::Mat hdrImage;
	cv::Mat ghostLo;
	cv::Mat ghostHi;
	cv::Mat histogramImages[3];
	cv::Mat diffHistogramImage;
	cv::Scalar colorMap[9] = {cv::Scalar(0,0,100), cv::Scalar(0,0,255), cv::Scalar(0,100,100), cv::Scalar(0,255,255), cv::Scalar(0,100,0), cv::Scalar(0,255,0), cv::Scalar(100,0,0), cv::Scalar(255,0,0), cv::Scalar(255,255,0)};
	
public:
	MultiHistogramMerge(){};

    virtual ~MultiHistogramMerge(){};

    void setSequence(std::vector<LdrMat> seq);
    
    void setParameters(std::vector<float> exposureRatios);

    void apply();

    cv::Mat getImage();

    void writeImages(std::string path);

private:

	int computeGhost(int blockSizeX, int blockSizeY);
	void merge(cv::Mat& ghostLo, cv::Mat& ghostHi);

};

}




#endif /* HDRLIB_MULTIHISTOGRAM_MERGE_HPP_ */
