/*
 * hdrlib_histogram_merge.hpp
 *
 *  Created on: 3. 11. 2017
 *      Author: nosko
 */

#ifndef HDRLIB_HISTOGRAM_MERGE_HPP_
#define HDRLIB_HISTOGRAM_MERGE_HPP_

#include <vector>
#include "hdrlib_base.hpp"
#include "hdrlib_composer_intf.hpp"

#include "opencv2/imgproc/imgproc.hpp"
#include "opencv2/imgproc/imgproc_c.h"
#define cvQueryHistValue_1D( hist, idx0 ) \
cvGetReal1D( (hist)->bins, (idx0) )

namespace hdr
{

class HistogramMerge : public ComposerInterface
{
private:
	std::vector<LdrMat> sequence;
	std::vector<float> exposureRatios;
	std::vector<float> ghostExposureRatios;
	cv::Mat hdrImage;
	cv::Mat ghost;

public:
	HistogramMerge(){};

    virtual ~HistogramMerge(){};

    void setSequence(std::vector<LdrMat> seq);
    
    void setParameters(std::vector<float> exposureRatios);

    void apply();

    cv::Mat getImage();

    void writeImages(std::string path);

private:

	cv::Mat computeGhost(int blockSizeX, int blockSizeY);
	void merge(cv::Mat& ghost);

};

}




#endif /* HDRLIB_HISTOGRAM_MERGE_HPP_ */
