#!/usr/bin/perl

use warnings;

use Net::NfDump qw ':all';
use Data::Dumper;
use NetAddr::IP::Lite;

my $flow = new Net::NfDump(InputFiles => $ARGV[0],
								Filter => $ARGV[1],
								Fields => 'proto, srcip, srcport, dstip, dstport, bgpnexthop' );

$flow->query();

while (my ($proto, $srcip, $srcport, $dstip, $dstport, $bgp) = $flow->fetchrow_array() )  {
	print "$proto " . ip2txt($srcip) . ":$srcport -> " . ip2txt($dstip) . ":$dstport bgp ip " . ip2txt($bgp) . " id " .  unpack("N", $bgp) . "\n";     
}

$flow->finish();
