#!/usr/bin/perl

use warnings;
no warnings 'uninitialized';

use Net::IP::LPM;
use Net::NfDump qw ':all';
use Data::Dumper;

my $flow_src = new Net::NfDump(InputFiles => \@ARGV, Fields => 'srcip,dstip,srcport,dstport,bgpnexthop' );
my $flow_dst = new Net::NfDump(OutputFile => 'nfdump_file_out',Fields => 'srcip,dstip,srcport,dstport,xsrcport,xdstport,xsrcip,xdstip' ); 

$flow_src->query();
$flow_dst->create();

my $lpm = Net::IP::LPM->new();
$lpm->add('192.168.1.0/24', 'inside');
$lpm->rebuild();

my %hash = ();

while (my ($srcip, $dstip, $srcport, $dstport, $bgpnexthop) = $flow_src->fetchrow_array()) {
    if ($hash{$bgpnexthop}) { #found
        print "found in hash \n";
        my ($a, $b, $c, $d) = @{$hash{$bgpnexthop}};
        print " src ip: " . ip2txt($srcip) . " src port $srcport, dst ip " . ip2txt($dstip) . " dst port $dstport\n";
        print " stored src ip: " . ip2txt($a) . " src port $c, stored dst ip " . ip2txt($b) . " dst port $d\n";      
        if ($lpm->lookup_raw($srcip) eq 'inside') {
            #flow direction from NAT to outside. Actual flow is before translation, stored record is after translation 
            print ip2txt($srcip) ." -> " . ip2txt($a) . " -> " . ip2txt($a) . " -> " . ip2txt($dstip) . "\n";
            $flow_dst->clonerow($flow_src);
            $flow_dst->storerow_array($srcip,$dstip,$srcport,$dstport,$c,$d,$a,$b);
            next;
        }
        if ($lpm->lookup_raw($a) eq 'inside') {
            #flow direction from NAT to outside. Actual flow is after translation, stored record is before translation 
            print ip2txt($a) ." -> " . ip2txt($srcip) . " -> " . ip2txt($srcip) . " -> " . ip2txt($dstip) . "\n";
            $flow_dst->clonerow($flow_src);
            $flow_dst->storerow_array($a,$b,$c,$d,$srcport,$dstport,$srcip,$dstip);
            next;
        }
        if ($lpm->lookup_raw($dstip) eq 'inside') {
            #flow direction from outside to NAT. Actual flow is after translation, stored record is before translation 
            print ip2txt($a) ." -> " . ip2txt($b) . " -> " . ip2txt($b) . " -> " . ip2txt($dstip) . "\n";
            $flow_dst->clonerow($flow_src);
            $flow_dst->storerow_array($a,$b,$c,$d,$srcport,$dstport,$a,$dstip);
            next;
        }
        if ($lpm->lookup_raw($b) eq 'inside') {
            #flow direction from outside to NAT. Actual flow is before translation, stored record is after translation 
            print ip2txt($srcip) ." -> " . ip2txt($dstip) . " -> " . ip2txt($dstip) . " -> " . ip2txt($b) . "\n";
            $flow_dst->clonerow($flow_src);
            $flow_dst->storerow_array($srcip,$dstip,$srcport,$dstport,$c,$d,$srcip,$b);
        }

    } else {
        print "Didn't find, adding\n";
        my $array = [];
        push (@$array, $srcip);
        push (@$array, $dstip);
        push (@$array, $srcport);
        push (@$array, $dstport);
        $hash{$bgpnexthop} = $array;
    }
}

