#include "VideoReader.h"

VideoReader::VideoReader()
{
	this->init();
}

VideoReader::VideoReader(std::string &in_file, int &width, int &height, bool repeat, std::stringstream *error)
{
	this->init();
	this->openFile(in_file, width, height, repeat, error);
}

VideoReader::~VideoReader(void)
{
	this->closeFile();
}

void VideoReader::init()
{
	this->open = false;
}

bool VideoReader::isOpen()
	{
		return this->open;
	}

bool VideoReader::openFile(std::string &in_file, int &width, int &height, bool repeat, std::stringstream *error)
{
  this->closeFile();
  if(!(this->open = video.open(in_file)))
    {
      return false;
    }
  this->frame_count = (unsigned int)(video.get(CV_CAP_PROP_FRAME_COUNT));
  width = (int)(video.get(CV_CAP_PROP_FRAME_WIDTH));
  height = (int)(video.get(CV_CAP_PROP_FRAME_HEIGHT));
	this->v_file = in_file;
  this->repeat = repeat;
  return true;
}

bool VideoReader::getFrame(void **bgra_out_frame, std::stringstream *error)
	{
    // warning: CV_CAP_PROP_FRAME_COUNT has sometimes inaccurate value
    if((!this->isOpen()) ||
       ((!video.read(bgr_frame)) &&
        ((!this->repeat) || (!this->setFramePos(0)) || (!video.read(bgr_frame)))))
      {
        return false;
      }
    cvtColor(bgr_frame, bgra_frame, CV_BGR2BGRA);
    *bgra_out_frame = (void *)(bgra_frame.data);
    return true;
	}

bool VideoReader::setFramePos(unsigned int frame_pos)
  {
    if((!this->isOpen()) || (this->frame_count <= frame_pos) || (!video.set(CV_CAP_PROP_POS_FRAMES, (double)frame_pos)))
      {
        return false;
      }
    return true;
  }

void VideoReader::closeFile()
{
  if(this->isOpen())
    {
      video.release();
      this->open = false;
    }
}




