#include "CameraReader.h"

CameraReader::CameraReader()
{
	this->init();
}

CameraReader::CameraReader(std::string &in_file, int &width, int &height, bool repeat, std::stringstream *error)
{
	this->init();
	this->openFile(in_file, width, height, repeat, error);
}

CameraReader::~CameraReader(void)
{
	this->closeFile();
}

void CameraReader::init()
{
	this->open = false;
}

bool CameraReader::isOpen()
	{
		return this->open;
	}

bool CameraReader::openFile(std::string &in_file, int &width, int &height, bool repeat, std::stringstream *error)
{
  this->closeFile();
  if(!(this->open = video.open(atoi(in_file.c_str()))))
    {
      return false;
    }
  this->frame_count = (unsigned int)(video.get(CV_CAP_PROP_FRAME_COUNT));
  video.set(CV_CAP_PROP_FRAME_WIDTH, 1280);
  video.set(CV_CAP_PROP_FRAME_HEIGHT, 720);
  width = (int)(video.get(CV_CAP_PROP_FRAME_WIDTH));
  height = (int)(video.get(CV_CAP_PROP_FRAME_HEIGHT));
	this->v_file = in_file;
  return true;
}

bool CameraReader::getFrame(void **bgra_out_frame, std::stringstream *error)
	{
    // warning: CV_CAP_PROP_FRAME_COUNT has sometimes inaccurate value
    if((!this->isOpen()) || (!video.read(bgr_frame))) return false;
    cvtColor(bgr_frame, bgra_frame, CV_BGR2BGRA);
    *bgra_out_frame = (void *)(bgra_frame.data);
    return true;
	}

bool CameraReader::setFramePos(unsigned int frame_pos)
  {
    if((!this->isOpen()) || (this->frame_count <= frame_pos) || (!video.set(CV_CAP_PROP_POS_FRAMES, (double)frame_pos)))
      {
        return false;
      }
    return true;
  }

void CameraReader::closeFile()
{
  if(this->isOpen())
    {
      video.release();
      this->open = false;
    }
}




