#ifndef WAVELET_OPENCL_PARAM_H
#define WAVELET_OPENCL_PARAM_H

#include "main.h"
#include "Wavelet.h"
#include "WaveletParam.h"
#include <sstream>

typedef enum e_wavelet_proc_type
{
    WAVELET_PROC_TYPE_BLAZ_NORMAL = 0,
    WAVELET_PROC_TYPE_BLAZ_REGISTER,
    WAVELET_PROC_TYPE_LAAN
}wavelet_proc_type;

typedef enum e_opencl_dev_type
{
  OPENCL_DEV_TYPE_GPU = 0,
  OPENCL_DEV_TYPE_CPU
}opencl_dev_type;

typedef enum e_opencl_mem_type
{
  OPENCL_MEM_TYPE_GLOBAL = 0,
  OPENCL_MEM_TYPE_TEXTURE
}opencl_mem_type;

typedef struct s_proc_dim
  {
    size_t x; ///< first size
    size_t y; ///< second size 
    size_t z; ///< third size
    /**
     * Initialize structure by 0 sizes.
     */
    s_proc_dim()
      {
        this->clear();
      };
    /**
     * Create flat 3 element structure from actual structure
     * @return flat structure
     */
    s_proc_dim flat()
      {
        return s_proc_dim(this->x*this->y*this->z);
      }
    void alignTo(s_proc_dim &align)
      {
        this->x = this->alignTo(x, align.x);
        this->y = this->alignTo(y, align.y);
        this->z = this->alignTo(z, align.z);
      }
    /**
     * Initialize structure by user sizes.
     * @param x first size
     * @param y second size
     * @param z third size
     */
    s_proc_dim(size_t x, size_t y = 1, size_t z = 1)
      {
        this->x = x;
        this->y = y;
        this->z = z;
      };
    /**
     * Clear structure by setting 0 to sizes.
     */
    void clear()
      {
        this->x = 0;
        this->y = 0;
        this->z = 0;
      }
    /**
     * Get total thread/group count.
     * @return total thread/group count
     */
    size_t count()
      {
        return this->x * this->y * this->z;
      };
    private:
      size_t alignTo(size_t num, size_t align)
        {
          return ((num + align - 1)/align)*align;
        }
  }proc_dim;

/**
 * @brief Program parameters structure
 */
class WaveletOpenclParam : public WaveletParam
  {
    public:

		  WaveletOpenclParam(engine_type in_engine = ENGINE_TYPE_OPENCL_SEP);

      void clear();

      virtual std::string createBuildParam();

      void printDebug();
      size_t vert_pairs;
      size_t hor_pairs;
      cl_device_type dev_type;
      bool atomic_warp;
      cl_uint warp_size;
      wavelet_proc_type vert_proc;
      wavelet_proc_type hor_proc;
      cl_uint dev_id;
      cl_uint subdevice_size;
      opencl_mem_type image_mem_type;
      bool double_buffering;
      bool memless_exec;
      bool benchmark_proc;
      cl_uint repeat_count;
      bool gen_filter_body;
  };

#endif
