#include "ImageReader.h"

ImageReader::ImageReader()
{
	this->init();
}

ImageReader::ImageReader(std::string &in_file, int &width, int &height, bool repeat, std::stringstream *error)
{
	this->init();
	this->openFile(in_file, width, height, repeat, error);
}

ImageReader::~ImageReader(void)
{
	this->closeFile();
}

void ImageReader::init()
{
	this->open = false;
  this->first = false;
}

bool ImageReader::isOpen()
	{
		return this->open;
	}

bool ImageReader::isReady()
  {
    return this->first && this->isOpen();
  }

bool ImageReader::openFile(std::string &in_file, int &width, int &height, bool repeat, std::stringstream *error)
{
  this->closeFile();
  bgr_frame = cv::imread(in_file);
  if((bgr_frame.data == NULL) || (bgr_frame.dims > 2))
    {
      return false;
    }
  width = bgr_frame.cols;
  height = bgr_frame.rows;
  this->open = true;
  this->first = true;
  this->repeat = repeat;
  return true;
}

bool ImageReader::getFrame(void **bgra_out_frame, std::stringstream *error)
	{
    if(!this->isOpen()) return false;
    if(!this->first)
      {
        if((!repeat) || (!this->setFramePos(0)))
          {
            return false;
          }
      }
    cvtColor(bgr_frame, bgra_frame, CV_BGR2BGRA);
    *bgra_out_frame = (void *)(bgra_frame.data);
    this->first = false;
    return true;
	}

bool ImageReader::setFramePos(unsigned int frame_pos)
  {
    if((!this->isOpen()) || (frame_pos != 0))
      {
        return false;
      }
    this->first = true;
    return true;
  }

void ImageReader::closeFile()
{
  this->init();
}




