#ifndef WAVELET_OPENCL_PARAM_COMB_H
#define WAVELET_OPENCL_PARAM_COMB_H

#include "main.h"
#include "Wavelet.h"
#include "WaveletOpenclParam.h"
#include <sstream>
#include <iostream>
#include <opencv2/core/core.hpp>
#include <opencv2/highgui/highgui.hpp>

/**
 * @brief Program parameters structure
 */
class WaveletOpenclParamComb : public WaveletOpenclParam
  {
    public:
		  /**
       * Default constructor for set initial undefined value.
       */
		  WaveletOpenclParamComb();
		  /**
       * Get program build parameters.
		   * @param block_size threads in block count
		   * @param stat_creating statistics creating type
		   * @return parameters
       */
      std::string createBuildParam();
      /**
       * Print debug information
       */
      void printDebug();
      void clear();
      proc_dim comb_sizes;
      std::string comb_kernel;
      cl_uint comb_hor_corners_proc;
   private:
      std::string getFirDef(std::vector<float> &fir, std::string &filter_name);
      void getFirData(int stages, int filter_length, float *coef, float norm_coef, std::vector<float> &fir_ll, std::vector<float> &fir_hl, std::vector<float> &fir_lh, std::vector<float> &fir_hh, bool improved);
      void createFirFilter(int stages, int filter_length, float *coef, cv::Mat &fir_ll_m, cv::Mat &fir_hl_m, cv::Mat &fir_lh_m, cv::Mat &fir_hh_m, bool improved);
      std::string getFirStepBody(int stages, int filter_length, float *coef, float norm_coef, int iter_id, std::vector<float> *fir_ll, std::vector<float> *fir_hl, std::vector<float> *fir_lh, std::vector<float> *fir_hh, bool improved);
      std::string getFirDefs();

  };

#endif
