#ifndef EMPTY_READER_H
#define EMPTY_READER_H
#include <iostream>
#include <string>
#include <sstream>

#include <opencv2/core/core.hpp>
#include <opencv2/highgui/highgui.hpp>
#include <opencv2/imgproc/imgproc.hpp>

#include "Debug.h"
#include "FileReaderInterface.h"

#define EMPTY_READER_WIDTH 200
#define EMPTY_READER_HEIGHT 50

/**
 * @brief Video getting class
 */
class EmptyReader: public FileReaderInterface
{
public:
  /**
   * Initialize object and register ffmpeg codec.
   */
  EmptyReader();
  /**
   * Initialize object, register ffmpeg codec and open video file.
   * @param v_file video file path
   * @param width width of loaded video or 0 if fail
   * @param height height of loaded video or 0 if fail
   * @param error optional string to write error
   */
  EmptyReader(std::string &v_file, int &width, int &height, bool repeat, std::stringstream *error = NULL);
  /**
   * Close video file if opened.
   */
  ~EmptyReader();
  /**
   * Return file open state.
   * @return file open state
   */
	bool isOpen();
  /**
   * Open video file.
   * @param v_file video file path
   * @param width width of loaded video or 0 if fail
   * @param height height of loaded video or 0 if fail
   * @param error optional string to write error
   * @return success of open file
   */
	bool openFile(std::string &v_file, int &width, int &height, bool repeat, std::stringstream *error = NULL);
  bool setFramePos(unsigned int frame_pos);
  /**
   * Close video file if opened.
   */
	void closeFile();
  /**
   * Get next frame.
   * @param bgra_frame output frame
   * @param error optional string to write error
   * @return true if return regular frame or false if reach end of file
   */
	bool getFrame(void **bgra_out_frame, std::stringstream *error = NULL);
private:
  /**
   * Initialize object and register ffmpeg codec.
   */
  void init();

	bool open;

  cv::Mat bgra_frame;
};

#endif

