#include "EmptyReader.h"

EmptyReader::EmptyReader()
{
	this->init();
}

EmptyReader::EmptyReader(std::string &in_file, int &width, int &height, bool repeat, std::stringstream *error)
{
	this->init();
	this->openFile(in_file, width, height, repeat, error);
}

EmptyReader::~EmptyReader(void)
{
	this->closeFile();
}

void EmptyReader::init()
{
	this->open = false;
}

bool EmptyReader::isOpen()
	{
		return this->open;
	}

bool EmptyReader::openFile(std::string &in_file, int &width, int &height, bool repeat, std::stringstream *error)
{
  this->closeFile();
  this->open = true;
  width = EMPTY_READER_WIDTH;
  height = EMPTY_READER_HEIGHT;
  return true;
}

bool EmptyReader::getFrame(void **bgra_out_frame, std::stringstream *error)
	{
    // warning: CV_CAP_PROP_FRAME_COUNT has sometimes inaccurate value
    if(!this->isOpen())
      {
        return false;
      }
    bgra_frame = cv::Mat::zeros(EMPTY_READER_HEIGHT, EMPTY_READER_WIDTH, CV_8UC4);
    *bgra_out_frame = (void *)(bgra_frame.data);
    return true;
	}

bool EmptyReader::setFramePos(unsigned int frame_pos)
  {
    return true;
  }

void EmptyReader::closeFile()
{
  this->open = false;
}




