#include "system.h"
#include <stdio.h>
#include <signal.h>
#include <stdlib.h>
#include <execinfo.h>
#include <unistd.h>
#include "transform.h"

void handler(int sig)
{
	void *buffer[256];

	size_t size = backtrace(buffer, 256);

	fprintf(stderr, "Error: received signal %d:\n", sig);

	backtrace_symbols_fd(buffer+2, size-2, STDERR_FILENO);

	exit(EXIT_FAILURE);
}

void system_setup_debug()
{
	signal(SIGSEGV, handler);

	setvbuf(stdout, NULL, _IONBF, 0);
	setvbuf(stderr, NULL, _IONBF, 0);
}

void system_crash()
{
	*(int *)NULL = 0;
}

// verifies the existence of a bug #1
int system_check_bug1()
{
	dprintf("checking for a bug #1...\n");

	const int N = 2;

	const struct vec2_t cb_exp = { 6, 6 };

	const struct vec2_t tc0 = { 1, 2 };
	const struct vec2_t size = { 781, 15625 };
	const struct vec2_t tc1 = vec2_add(tc0, size);

	struct imageptr_t *imageptr = imageptr_create_sparse(size);

	imageptr_fill(imageptr, size);

	if( transform_process_tile(tc0, tc1, cb_exp, N, imageptr) )
		return -1;

	imageptr_destroy_sparse(imageptr, size);

	dprintf("the bug is not present\n");

	return 0;
}

// verifies the existence of a bug #2
int system_check_bug2()
{
	dprintf("checking for a bug #2...\n");

	const int N = 1;

	const struct vec2_t cb_exp = { 6, 6 };

	const struct vec2_t tc0 = { 1, 1 };

	const struct vec2_t size = { 172, 130 };

	const struct vec2_t tc1 = vec2_add(tc0, size);

	{
		struct imageptr_t *imageptr = imageptr_create_sparse(size);

		if( !imageptr )
			return -1;

		struct transform_t *transform = transform_create(
			tc0,
			tc1,
			cb_exp,
			1,
			N,
			NULL,
			NULL
		);

		if( !transform )
			return -1;

		while( !transform_finished(transform) )
		{
			const struct range2_t lines = transform_prepare_strip(transform);

			const struct vec2_t data_offset = { 0, lines.i0 };
			const struct vec2_t data_size = { size.x, lines.i1 - lines.i0 };

			struct imageptr_t *data_lines = imageptr_viewport(imageptr, data_offset);

			imageptr_fill_strip(
				data_lines,
				data_offset,
				data_size
			);

			free(data_lines);

			transform_process_strip(
				transform,
				imageptr,
				vec2_zero
			);

			imageptr_discard_sparse(
				imageptr,
				vec2_create( 0, lines.i1 )
			);
		}

		transform_destroy(transform);

		imageptr_destroy_sparse(imageptr, size);
	}

	dprintf("the bug is not present\n");

	return 0;
}

// verifies the existence of a bug #3
int system_check_bug3()
{
	const int N = 8;

	const struct vec2_t cb_exp = { 6, 6 };
	const struct vec2_t tc0 = { 5, 128 };
	const struct vec2_t size = { 1024, 1024 };
	const struct vec2_t tc1 = vec2_add(tc0, size);

	struct imageptr_t *imageptr = imageptr_create_sparse(size);

	imageptr_fill(imageptr, size);

	if( transform_process_tile(tc0, tc1, cb_exp, N, imageptr) )
		return -1;

	imageptr_destroy_sparse(imageptr, size);

	return 0;
}
