/*
 * File:     squares.h, compiled by gcc
 * Date:     2009-02-02 21:03:54 
 * Author:   Bronislav Pribyl, xpriby12@stud.fit.vutbr.cz
 * Project:  Separable image resampling
 * Encoding: utf-8
 * Version:  1.5
 * Desc:     Module to handle coordinates for interpolation algorithm
 */


typedef struct point2D{
	long unsigned int x;	/**< x-dimension */
	long unsigned int y;	/**< y-dimension */
}TPoint2D;

typedef struct coordinatesSquare{
	TPoint2D S0;			/**< Starting position */
	TPoint2D DC0;		/**< X - increment */
	TPoint2D DR;		/**< Y - increment */
	TPoint2D DDC;		/**< Increment of X - increment */
}TCoordsSquare;

typedef struct coordinates{
	int sqSize;             /**< Size of square in pixels */
	int xSquares;           /**< Number of squares horizontally */
	int ySquares;           /**< Number of squares vertically */
	TCoordsSquare *squares; /**< Array of structures with square coeficients */
}TCoords;



/**
 * Initializes structure of coefficients of one square.
 * @param coords Pointer to structure of coefficients of one square
 * @param fileName Name of text file with square coefficients
 */
void coordsInitialize(TCoords *coords, char *fileName);


/**
 * Prints coefficients of all squares.
 * @param coords Pointer to structure with coefficients of all squares
 */
void coordsPrint(TCoords *coords);


/**
 * Initializes structure of coefficients of one square.
 * @param coords Pointer to structure with coefficients of one square
 * @param S0 Value of S0 coefficient
 * @param DC0 Value of DC0 coefficient
 * @param DR Value of DR coefficient
 * @param DDC Value of DDC coefficient
 */
void coordsInitializeSquare(TCoordsSquare *coords, TPoint2D S0, TPoint2D DC0, TPoint2D DR, TPoint2D DDC);


/**
 * Prints coefficients of one square.
 * @param coords Pointer to structure with coefficients of one square
 */
void coordsPrintSquare(TCoordsSquare *coords);
 
/* end of file squares.h */

